/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class EntityMode
implements Serializable {
    private static final Map INSTANCES = new HashMap();
    public static final EntityMode POJO = new EntityMode("pojo");
    public static final EntityMode DOM4J = new EntityMode("dom4j");
    public static final EntityMode MAP = new EntityMode("dynamic-map");
    private final String name;

    public EntityMode(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    private Object readResolve() {
        return INSTANCES.get(this.name);
    }

    public static EntityMode parse(String string) {
        EntityMode entityMode = (EntityMode)INSTANCES.get(string);
        if (entityMode == null) {
            entityMode = POJO;
        }
        return entityMode;
    }

    static {
        INSTANCES.put(EntityMode.POJO.name, POJO);
        INSTANCES.put(EntityMode.DOM4J.name, DOM4J);
        INSTANCES.put(EntityMode.MAP.name, MAP);
    }
}

