/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public class ReflectUtils {
    private static StringBuilder appendTypeName(StringBuilder stringBuilder, Type type, boolean bl) {
        if (type instanceof Class) {
            Class<?> clazz = (Class<?>)type;
            if (clazz.isArray()) {
                try {
                    int n = 0;
                    while (clazz.isArray()) {
                        ++n;
                        clazz = clazz.getComponentType();
                    }
                    stringBuilder.append(clazz.getName());
                    for (int i = 0; i < n; ++i) {
                        if (bl) {
                            stringBuilder.append("...");
                            continue;
                        }
                        stringBuilder.append("[]");
                    }
                    return stringBuilder;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            stringBuilder.append(clazz.getName());
        } else {
            stringBuilder.append(type.toString());
        }
        return stringBuilder;
    }

    public static Class<?> findGenericClassFor(Class<?> clazz, Class<?> clazz2) {
        GenericRef genericRef = new GenericRef(clazz, clazz2);
        if (ReflectUtils.resolveGenericRef(genericRef, clazz)) {
            return genericRef.genericClass;
        }
        return null;
    }

    private static int findTypeParameterIndex(Class<?> clazz, TypeVariable<?> typeVariable) {
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        for (int i = 0; i < typeVariableArray.length; ++i) {
            if (!typeVariableArray[i].getName().equals(typeVariable.getName())) continue;
            return i;
        }
        return -1;
    }

    public static boolean isDefaultConstructable(Class<?> clazz) {
        int n = clazz.getModifiers();
        if (Modifier.isAbstract(n) || !Modifier.isPublic(n)) {
            return false;
        }
        Class[] classArray = new Class[]{};
        try {
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return Modifier.isPublic(constructor.getModifiers());
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return false;
        }
    }

    private static boolean resolveGenericRef(GenericRef genericRef, Class<?> clazz, Type type) {
        if (type instanceof Class) {
            if (type == genericRef.ifaceClass) {
                genericRef.setGenericFromType(type, 0);
                return true;
            }
            return ReflectUtils.resolveGenericRef(genericRef, type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type type2 = parameterizedType.getRawType();
            if (type2 == genericRef.ifaceClass) {
                genericRef.setGenericFromType(parameterizedType.getActualTypeArguments()[0], 0);
                return true;
            }
            return ReflectUtils.resolveGenericRef(genericRef, type2);
        }
        return false;
    }

    private static boolean resolveGenericRef(GenericRef genericRef, Type type) {
        ParameterizedType parameterizedType;
        Class clazz;
        if (type == null || type == Object.class) {
            return false;
        }
        if (type instanceof Class) {
            Type[] typeArray;
            Class clazz2 = (Class)type;
            if (clazz2.getName().matches("^javax*\\..*")) {
                return false;
            }
            for (Type type2 : typeArray = clazz2.getGenericInterfaces()) {
                if (!ReflectUtils.resolveGenericRef(genericRef, clazz2, type2)) continue;
                if (genericRef.needsUnwrap()) {
                    TypeVariable typeVariable = (TypeVariable)genericRef.genericType;
                    int n = ReflectUtils.findTypeParameterIndex(clazz2, typeVariable);
                    if (n >= 0) {
                        TypeVariable<Class<T>>[] typeVariableArray = clazz2.getTypeParameters();
                        if (typeVariableArray.length >= n) {
                            genericRef.setGenericFromType(typeVariableArray[n], n);
                        }
                    } else if (type2 instanceof ParameterizedType) {
                        Type type3 = ((ParameterizedType)type2).getActualTypeArguments()[genericRef.genericIndex];
                        genericRef.setGenericFromType(type3, genericRef.genericIndex);
                    }
                }
                return true;
            }
            type = clazz2.getGenericSuperclass();
            return ReflectUtils.resolveGenericRef(genericRef, type);
        }
        if (type instanceof ParameterizedType && ReflectUtils.resolveGenericRef(genericRef, clazz = (Class)(parameterizedType = (ParameterizedType)type).getRawType()) && genericRef.needsUnwrap()) {
            TypeVariable typeVariable = (TypeVariable)genericRef.genericType;
            int n = ReflectUtils.findTypeParameterIndex(clazz, typeVariable);
            Type type4 = parameterizedType.getActualTypeArguments()[n];
            genericRef.setGenericFromType(type4, n);
            return true;
        }
        return false;
    }

    public static String toShortName(Type type) {
        if (type == null) {
            return "<null>";
        }
        if (type instanceof Class) {
            String string = ((Class)type).getName();
            return ReflectUtils.trimClassName(string);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ReflectUtils.trimClassName(((Class)parameterizedType.getRawType()).getName()));
            stringBuilder.append("<");
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            for (int i = 0; i < typeArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(typeArray[i]);
            }
            stringBuilder.append(">");
            return stringBuilder.toString();
        }
        return type.toString();
    }

    public static String toString(Class<?> clazz, Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = method.getModifiers() & Modifier.methodModifiers();
        if (n != 0) {
            stringBuilder.append(Modifier.toString(n)).append(' ');
        }
        Type type = method.getGenericReturnType();
        ReflectUtils.appendTypeName(stringBuilder, type, false).append(' ');
        stringBuilder.append(clazz.getName());
        stringBuilder.append("#");
        stringBuilder.append(method.getName());
        stringBuilder.append('(');
        Type[] typeArray = method.getGenericParameterTypes();
        for (int i = 0; i < typeArray.length; ++i) {
            boolean bl = method.isVarArgs() && i == typeArray.length - 1;
            ReflectUtils.appendTypeName(stringBuilder, typeArray[i], bl);
            if (i >= typeArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static String trimClassName(String string) {
        int n = string.lastIndexOf(46);
        if ((n = (string = string.substring(n + 1)).lastIndexOf(36)) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private static class GenericRef {
        private final Class<?> baseClass;
        private final Class<?> ifaceClass;
        Class<?> genericClass;
        public Type genericType;
        private int genericIndex;

        public GenericRef(Class<?> clazz, Class<?> clazz2) {
            this.baseClass = clazz;
            this.ifaceClass = clazz2;
        }

        public boolean needsUnwrap() {
            return this.genericClass == null && this.genericType != null && this.genericType instanceof TypeVariable;
        }

        public void setGenericFromType(Type type, int n) {
            this.genericType = type;
            this.genericIndex = n;
            if (type instanceof Class) {
                this.genericClass = (Class)type;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("GenericRef [baseClass=");
            stringBuilder.append(this.baseClass);
            stringBuilder.append(", ifaceClass=");
            stringBuilder.append(this.ifaceClass);
            stringBuilder.append(", genericType=");
            stringBuilder.append(this.genericType);
            stringBuilder.append(", genericClass=");
            stringBuilder.append(this.genericClass);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

