/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Utf8Appendable;

public class Utf8CharBuffer
extends Utf8Appendable {
    private final CharBuffer buffer;

    public static Utf8CharBuffer wrap(ByteBuffer byteBuffer) {
        return new Utf8CharBuffer(byteBuffer.asCharBuffer());
    }

    private Utf8CharBuffer(CharBuffer charBuffer) {
        super(charBuffer);
        this.buffer = charBuffer;
    }

    public void append(char[] cArray, int n, int n2) {
        this.append(BufferUtil.toDirectBuffer(new String(cArray, n, n2), StandardCharsets.UTF_8));
    }

    public void append(int n) {
        this.buffer.append((char)n);
    }

    @Override
    public void reset() {
        this.clear();
        super.reset();
    }

    public void clear() {
        this.buffer.position(0);
        this.buffer.limit(this.buffer.capacity());
    }

    public ByteBuffer getByteBuffer() {
        int n = this.buffer.limit();
        int n2 = this.buffer.position();
        this.buffer.limit(this.buffer.position());
        this.buffer.position(0);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(this.buffer);
        this.buffer.limit(n);
        this.buffer.position(n2);
        return byteBuffer;
    }

    @Override
    public int length() {
        return this.buffer.capacity();
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    @Override
    public String getPartialString() {
        return this.buffer.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Utf8CharBuffer@").append(this.hashCode());
        stringBuilder.append("[p=").append(this.buffer.position());
        stringBuilder.append(",l=").append(this.buffer.limit());
        stringBuilder.append(",c=").append(this.buffer.capacity());
        stringBuilder.append(",r=").append(this.buffer.remaining());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

