/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.BlockingWriteCallback;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.message.Utf8CharBuffer;

public class MessageWriter
extends Writer {
    private static final Logger LOG = Log.getLogger(MessageWriter.class);
    private final OutgoingFrames outgoing;
    private final ByteBufferPool bufferPool;
    private final BlockingWriteCallback blocker;
    private long frameCount;
    private TextFrame frame;
    private ByteBuffer buffer;
    private Utf8CharBuffer utf;
    private WriteCallback callback;
    private boolean closed;

    public MessageWriter(WebSocketSession webSocketSession) {
        this(webSocketSession.getOutgoingHandler(), webSocketSession.getPolicy().getMaxTextMessageBufferSize(), webSocketSession.getBufferPool());
    }

    public MessageWriter(OutgoingFrames outgoingFrames, int n, ByteBufferPool byteBufferPool) {
        this.outgoing = outgoingFrames;
        this.bufferPool = byteBufferPool;
        this.blocker = new BlockingWriteCallback();
        this.buffer = byteBufferPool.acquire(n, true);
        BufferUtil.flipToFill(this.buffer);
        this.frame = new TextFrame();
        this.utf = Utf8CharBuffer.wrap(this.buffer);
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        try {
            this.send(cArray, n, n2);
        }
        catch (Throwable throwable) {
            this.notifyFailure(throwable);
            throw throwable;
        }
    }

    @Override
    public void write(int n) throws IOException {
        try {
            this.send(new char[]{(char)n}, 0, 1);
        }
        catch (Throwable throwable) {
            this.notifyFailure(throwable);
            throw throwable;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.flush(false);
        }
        catch (Throwable throwable) {
            this.notifyFailure(throwable);
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush(true);
            this.bufferPool.release(this.buffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream closed, {} frames sent", this.frameCount);
            }
            this.notifySuccess();
        }
        catch (Throwable throwable) {
            this.notifyFailure(throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(boolean bl) throws IOException {
        MessageWriter messageWriter = this;
        synchronized (messageWriter) {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            this.closed = bl;
            ByteBuffer byteBuffer = this.utf.getByteBuffer();
            if (LOG.isDebugEnabled()) {
                LOG.debug("flush({}): {}", bl, BufferUtil.toDetailString(this.buffer));
            }
            this.frame.setPayload(byteBuffer);
            this.frame.setFin(bl);
            try (BlockingWriteCallback.WriteBlocker writeBlocker = this.blocker.acquireWriteBlocker();){
                this.outgoing.outgoingFrame(this.frame, writeBlocker, BatchMode.OFF);
                writeBlocker.block();
            }
            ++this.frameCount;
            this.frame.setIsContinuation();
            this.utf.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(char[] cArray, int n, int n2) throws IOException {
        MessageWriter messageWriter = this;
        synchronized (messageWriter) {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            while (n2 > 0) {
                int n3 = this.utf.remaining();
                int n4 = Math.min(n3, n2);
                this.utf.append(cArray, n, n4);
                n += n4;
                if ((n2 -= n4) <= 0) continue;
                this.flush(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(WriteCallback writeCallback) {
        MessageWriter messageWriter = this;
        synchronized (messageWriter) {
            this.callback = writeCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySuccess() {
        WriteCallback writeCallback;
        MessageWriter messageWriter = this;
        synchronized (messageWriter) {
            writeCallback = this.callback;
        }
        if (writeCallback != null) {
            writeCallback.writeSuccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFailure(Throwable throwable) {
        WriteCallback writeCallback;
        MessageWriter messageWriter = this;
        synchronized (messageWriter) {
            writeCallback = this.callback;
        }
        if (writeCallback != null) {
            writeCallback.writeFailed(throwable);
        }
    }
}

