/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.util.concurrent.Executor;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

class DefaultHttpClientProvider {
    DefaultHttpClientProvider() {
    }

    public static HttpClient newHttpClient(WebSocketContainerScope webSocketContainerScope) {
        SslContextFactory sslContextFactory = null;
        Executor executor = null;
        ByteBufferPool byteBufferPool = null;
        if (webSocketContainerScope != null) {
            sslContextFactory = webSocketContainerScope.getSslContextFactory();
            executor = webSocketContainerScope.getExecutor();
            byteBufferPool = webSocketContainerScope.getBufferPool();
        }
        if (sslContextFactory == null) {
            sslContextFactory = new SslContextFactory.Client();
            sslContextFactory.setTrustAll(false);
            sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        }
        HttpClient httpClient = new HttpClient(sslContextFactory);
        if (executor == null) {
            QueuedThreadPool queuedThreadPool = new QueuedThreadPool();
            String string = "WebSocketClient@" + httpClient.hashCode();
            queuedThreadPool.setName(string);
            queuedThreadPool.setDaemon(true);
            executor = queuedThreadPool;
        }
        httpClient.setExecutor(executor);
        if (byteBufferPool == null) {
            byteBufferPool = new MappedByteBufferPool();
        }
        httpClient.setByteBufferPool(byteBufferPool);
        return httpClient;
    }
}

