/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.api.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class QuoteUtil {
    public static final String ABNF_REQUIRED_QUOTING = "\"'\\\n\r\t\f\b%+ ;=";
    private static final char UNICODE_TAG = '\uffff';
    private static final char[] escapes = new char[32];

    private static int dehex(byte by) {
        if (by >= 48 && by <= 57) {
            return (byte)(by - 48);
        }
        if (by >= 97 && by <= 102) {
            return (byte)(by - 97 + 10);
        }
        if (by >= 65 && by <= 70) {
            return (byte)(by - 65 + 10);
        }
        throw new IllegalArgumentException("!hex:" + Integer.toHexString(0xFF & by));
    }

    public static String dequote(String string) {
        char c;
        char c2 = string.charAt(0);
        if ((c2 == '\'' || c2 == '\"') && c2 == (c = string.charAt(string.length() - 1))) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static void escape(StringBuilder stringBuilder, String string) {
        for (char c : string.toCharArray()) {
            if (c >= ' ') {
                if (c == '\"' || c == '\\') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c);
                continue;
            }
            char c2 = escapes[c];
            if (c2 == '\uffff') {
                stringBuilder.append("\\u00");
                if (c < '\u0010') {
                    stringBuilder.append('0');
                }
                stringBuilder.append(Integer.toString(c, 16));
                continue;
            }
            stringBuilder.append('\\').append(c2);
        }
    }

    public static void quote(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"');
        QuoteUtil.escape(stringBuilder, string);
        stringBuilder.append('\"');
    }

    public static void quoteIfNeeded(StringBuilder stringBuilder, String string, String string2) {
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = string.codePointAt(i);
            if (string2.indexOf(n2) < 0) continue;
            QuoteUtil.quote(stringBuilder, string);
            return;
        }
        stringBuilder.append(string);
    }

    public static Iterator<String> splitAt(String string, String string2) {
        return new DeQuotingStringIterator(string.trim(), string2);
    }

    public static String unescape(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n <= 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n - 2);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl) {
                bl = false;
                switch (c) {
                    case 'n': {
                        stringBuilder.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuilder.append('\t');
                        break;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        break;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        break;
                    }
                    case '\\': {
                        stringBuilder.append('\\');
                        break;
                    }
                    case '/': {
                        stringBuilder.append('/');
                        break;
                    }
                    case '\"': {
                        stringBuilder.append('\"');
                        break;
                    }
                    case 'u': {
                        stringBuilder.append((char)((QuoteUtil.dehex((byte)string.charAt(i++)) << 24) + (QuoteUtil.dehex((byte)string.charAt(i++)) << 16) + (QuoteUtil.dehex((byte)string.charAt(i++)) << 8) + QuoteUtil.dehex((byte)string.charAt(i++))));
                        break;
                    }
                    default: {
                        stringBuilder.append(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String join(Object[] objectArray, String string) {
        if (objectArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(string);
            }
            if (objectArray[i] instanceof String) {
                stringBuilder.append('\"').append(objectArray[i]).append('\"');
                continue;
            }
            stringBuilder.append(objectArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String join(Collection<?> collection, String string) {
        if (collection == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Object obj : collection) {
            if (bl) {
                stringBuilder.append(string);
            }
            if (obj instanceof String) {
                stringBuilder.append('\"').append(obj).append('\"');
            } else {
                stringBuilder.append(obj);
            }
            bl = true;
        }
        return stringBuilder.toString();
    }

    static {
        Arrays.fill(escapes, '\uffff');
        QuoteUtil.escapes[8] = 98;
        QuoteUtil.escapes[9] = 116;
        QuoteUtil.escapes[10] = 110;
        QuoteUtil.escapes[12] = 102;
        QuoteUtil.escapes[13] = 114;
    }

    private static class DeQuotingStringIterator
    implements Iterator<String> {
        private final String input;
        private final String delims;
        private StringBuilder token;
        private boolean hasToken = false;
        private int i = 0;

        public DeQuotingStringIterator(String string, String string2) {
            this.input = string;
            this.delims = string2;
            int n = string.length();
            this.token = new StringBuilder(n > 1024 ? 512 : n / 2);
        }

        private void appendToken(char c) {
            if (this.hasToken) {
                this.token.append(c);
            } else {
                if (Character.isWhitespace(c)) {
                    return;
                }
                this.token.append(c);
                this.hasToken = true;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.hasToken) {
                return true;
            }
            State state = State.START;
            boolean bl = false;
            int n = this.input.length();
            while (this.i < n) {
                char c = this.input.charAt(this.i++);
                switch (state) {
                    case START: {
                        if (c == '\'') {
                            state = State.QUOTE_SINGLE;
                            this.appendToken(c);
                            break;
                        }
                        if (c == '\"') {
                            state = State.QUOTE_DOUBLE;
                            this.appendToken(c);
                            break;
                        }
                        this.appendToken(c);
                        state = State.TOKEN;
                        break;
                    }
                    case TOKEN: {
                        if (this.delims.indexOf(c) >= 0) {
                            return this.hasToken;
                        }
                        if (c == '\'') {
                            state = State.QUOTE_SINGLE;
                        } else if (c == '\"') {
                            state = State.QUOTE_DOUBLE;
                        }
                        this.appendToken(c);
                        break;
                    }
                    case QUOTE_SINGLE: {
                        if (bl) {
                            bl = false;
                            this.appendToken(c);
                            break;
                        }
                        if (c == '\'') {
                            this.appendToken(c);
                            state = State.TOKEN;
                            break;
                        }
                        if (c == '\\') {
                            bl = true;
                            break;
                        }
                        this.appendToken(c);
                        break;
                    }
                    case QUOTE_DOUBLE: {
                        if (bl) {
                            bl = false;
                            this.appendToken(c);
                            break;
                        }
                        if (c == '\"') {
                            this.appendToken(c);
                            state = State.TOKEN;
                            break;
                        }
                        if (c == '\\') {
                            bl = true;
                            break;
                        }
                        this.appendToken(c);
                    }
                }
            }
            return this.hasToken;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string = this.token.toString();
            this.token.setLength(0);
            this.hasToken = false;
            return QuoteUtil.dequote(string.trim());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported with this iterator");
        }

        private static enum State {
            START,
            TOKEN,
            QUOTE_SINGLE,
            QUOTE_DOUBLE;

        }
    }
}

