/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.api.extensions;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.websocket.api.util.QuoteUtil;

public class ExtensionConfig {
    private final String name;
    private final Map<String, String> parameters;

    public static ExtensionConfig parse(String string) {
        return new ExtensionConfig(string);
    }

    public static List<ExtensionConfig> parseEnum(Enumeration<String> enumeration) {
        ArrayList<ExtensionConfig> arrayList = new ArrayList<ExtensionConfig>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Iterator<String> iterator = QuoteUtil.splitAt(enumeration.nextElement(), ",");
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    arrayList.add(ExtensionConfig.parse(string));
                }
            }
        }
        return arrayList;
    }

    public static List<ExtensionConfig> parseList(String ... stringArray) {
        ArrayList<ExtensionConfig> arrayList = new ArrayList<ExtensionConfig>();
        for (String string : stringArray) {
            Iterator<String> iterator = QuoteUtil.splitAt(string, ",");
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                arrayList.add(ExtensionConfig.parse(string2));
            }
        }
        return arrayList;
    }

    public static String toHeaderValue(List<ExtensionConfig> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (ExtensionConfig extensionConfig : list) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(extensionConfig.getParameterizedName());
            bl = true;
        }
        return stringBuilder.toString();
    }

    public ExtensionConfig(ExtensionConfig extensionConfig) {
        this.name = extensionConfig.name;
        this.parameters = new HashMap<String, String>();
        this.parameters.putAll(extensionConfig.parameters);
    }

    public ExtensionConfig(String string) {
        Iterator<String> iterator = QuoteUtil.splitAt(string, ";");
        this.name = iterator.next();
        this.parameters = new HashMap<String, String>();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            Iterator<String> iterator2 = QuoteUtil.splitAt(string2, "=");
            String string3 = iterator2.next().trim();
            String string4 = null;
            if (iterator2.hasNext()) {
                string4 = iterator2.next();
            }
            this.parameters.put(string3, string4);
        }
    }

    public String getName() {
        return this.name;
    }

    public final int getParameter(String string, int n) {
        String string2 = this.parameters.get(string);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    public final String getParameter(String string, String string2) {
        String string3 = this.parameters.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public final String getParameterizedName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        for (String string : this.parameters.keySet()) {
            stringBuilder.append(';');
            stringBuilder.append(string);
            String string2 = this.parameters.get(string);
            if (string2 == null) continue;
            stringBuilder.append('=');
            QuoteUtil.quoteIfNeeded(stringBuilder, string2, ";=");
        }
        return stringBuilder.toString();
    }

    public final Set<String> getParameterKeys() {
        return this.parameters.keySet();
    }

    public final Map<String, String> getParameters() {
        return this.parameters;
    }

    public final void init(ExtensionConfig extensionConfig) {
        this.parameters.clear();
        this.parameters.putAll(extensionConfig.parameters);
    }

    public final void setParameter(String string) {
        this.parameters.put(string, null);
    }

    public final void setParameter(String string, int n) {
        this.parameters.put(string, Integer.toString(n));
    }

    public final void setParameter(String string, String string2) {
        this.parameters.put(string, string2);
    }

    public String toString() {
        return this.getParameterizedName();
    }
}

