/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

public interface Invocable {
    public static final ThreadLocal<Boolean> __nonBlocking = new ThreadLocal();

    public static boolean isNonBlockingInvocation() {
        return Boolean.TRUE.equals(__nonBlocking.get());
    }

    public static void invokeNonBlocking(Runnable runnable) {
        Boolean bl = __nonBlocking.get();
        try {
            __nonBlocking.set(Boolean.TRUE);
            runnable.run();
        }
        finally {
            __nonBlocking.set(bl);
        }
    }

    public static InvocationType combine(InvocationType invocationType, InvocationType invocationType2) {
        if (invocationType != null && invocationType2 != null) {
            if (invocationType == invocationType2) {
                return invocationType;
            }
            if (invocationType == InvocationType.EITHER) {
                return invocationType2;
            }
            if (invocationType2 == InvocationType.EITHER) {
                return invocationType;
            }
        }
        return InvocationType.BLOCKING;
    }

    public static InvocationType getInvocationType(Object object) {
        if (object instanceof Invocable) {
            return ((Invocable)object).getInvocationType();
        }
        return InvocationType.BLOCKING;
    }

    default public InvocationType getInvocationType() {
        return InvocationType.BLOCKING;
    }

    public static enum InvocationType {
        BLOCKING,
        NON_BLOCKING,
        EITHER;

    }
}

