/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.thread.ReservedThreadExecutor;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.ThreadPoolBudget;
import org.eclipse.jetty.util.thread.TryExecutor;

@ManagedObject(value="A thread pool")
public class ExecutorThreadPool
extends ContainerLifeCycle
implements ThreadPool.SizedThreadPool,
TryExecutor {
    private final ThreadPoolExecutor _executor;
    private final ThreadPoolBudget _budget;
    private final ThreadGroup _group;
    private String _name = "etp" + this.hashCode();
    private int _minThreads;
    private int _reservedThreads = -1;
    private TryExecutor _tryExecutor = TryExecutor.NO_TRY;
    private int _priority = 5;
    private boolean _daemon;
    private boolean _detailedDump;

    public ExecutorThreadPool() {
        this(200, 8);
    }

    public ExecutorThreadPool(int n) {
        this(n, Math.min(8, n));
    }

    public ExecutorThreadPool(int n, int n2) {
        this(n, n2, new LinkedBlockingQueue<Runnable>());
    }

    public ExecutorThreadPool(int n, int n2, BlockingQueue<Runnable> blockingQueue) {
        this(new ThreadPoolExecutor(n, n, 60L, TimeUnit.SECONDS, blockingQueue), n2, -1, null);
    }

    public ExecutorThreadPool(ThreadPoolExecutor threadPoolExecutor) {
        this(threadPoolExecutor, -1);
    }

    public ExecutorThreadPool(ThreadPoolExecutor threadPoolExecutor, int n) {
        this(threadPoolExecutor, n, null);
    }

    public ExecutorThreadPool(ThreadPoolExecutor threadPoolExecutor, int n, ThreadGroup threadGroup) {
        this(threadPoolExecutor, Math.min(ProcessorUtils.availableProcessors(), threadPoolExecutor.getCorePoolSize()), n, threadGroup);
    }

    private ExecutorThreadPool(ThreadPoolExecutor threadPoolExecutor, int n, int n2, ThreadGroup threadGroup) {
        int n3 = threadPoolExecutor.getMaximumPoolSize();
        if (n3 < n) {
            threadPoolExecutor.shutdownNow();
            throw new IllegalArgumentException("max threads (" + n3 + ") cannot be less than min threads (" + n + ")");
        }
        this._executor = threadPoolExecutor;
        this._executor.setThreadFactory(this::newThread);
        this._group = threadGroup;
        this._minThreads = n;
        this._reservedThreads = n2;
        this._budget = new ThreadPoolBudget(this);
    }

    @ManagedAttribute(value="name of this thread pool")
    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._name = string;
    }

    @Override
    @ManagedAttribute(value="minimum number of threads in the pool")
    public int getMinThreads() {
        return this._minThreads;
    }

    @Override
    public void setMinThreads(int n) {
        this._minThreads = n;
    }

    @Override
    @ManagedAttribute(value="maximum number of threads in the pool")
    public int getMaxThreads() {
        return this._executor.getMaximumPoolSize();
    }

    @Override
    public void setMaxThreads(int n) {
        if (this._budget != null) {
            this._budget.check(n);
        }
        this._executor.setCorePoolSize(n);
        this._executor.setMaximumPoolSize(n);
    }

    @ManagedAttribute(value="maximum time a thread may be idle in ms")
    public int getIdleTimeout() {
        return (int)this._executor.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    public void setIdleTimeout(int n) {
        this._executor.setKeepAliveTime(n, TimeUnit.MILLISECONDS);
    }

    @ManagedAttribute(value="the number of reserved threads in the pool")
    public int getReservedThreads() {
        if (this.isStarted()) {
            return this.getBean(ReservedThreadExecutor.class).getCapacity();
        }
        return this._reservedThreads;
    }

    public void setReservedThreads(int n) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._reservedThreads = n;
    }

    public void setThreadsPriority(int n) {
        this._priority = n;
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    @ManagedAttribute(value="whether this thread pool uses daemon threads")
    public boolean isDaemon() {
        return this._daemon;
    }

    public void setDaemon(boolean bl) {
        this._daemon = bl;
    }

    @ManagedAttribute(value="reports additional details in the dump")
    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    public void setDetailedDump(boolean bl) {
        this._detailedDump = bl;
    }

    @Override
    @ManagedAttribute(value="number of threads in the pool")
    public int getThreads() {
        return this._executor.getPoolSize();
    }

    @Override
    @ManagedAttribute(value="number of idle threads in the pool")
    public int getIdleThreads() {
        return this._executor.getPoolSize() - this._executor.getActiveCount();
    }

    @Override
    public void execute(Runnable runnable) {
        this._executor.execute(runnable);
    }

    @Override
    public boolean tryExecute(Runnable runnable) {
        TryExecutor tryExecutor = this._tryExecutor;
        return tryExecutor != null && tryExecutor.tryExecute(runnable);
    }

    @Override
    @ManagedAttribute(value="thread pool is low on threads", readonly=true)
    public boolean isLowOnThreads() {
        return this.getThreads() == this.getMaxThreads() && this._executor.getQueue().size() >= this.getIdleThreads();
    }

    @Override
    protected void doStart() throws Exception {
        if (this._executor.isShutdown()) {
            throw new IllegalStateException("This thread pool is not restartable");
        }
        for (int i = 0; i < this._minThreads; ++i) {
            this._executor.prestartCoreThread();
        }
        this._tryExecutor = new ReservedThreadExecutor(this, this._reservedThreads);
        this.addBean(this._tryExecutor);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this._tryExecutor);
        this._tryExecutor = TryExecutor.NO_TRY;
        this._executor.shutdownNow();
        this._budget.reset();
    }

    @Override
    public void join() throws InterruptedException {
        this._executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public ThreadPoolBudget getThreadPoolBudget() {
        return this._budget;
    }

    protected Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this._group, runnable);
        thread.setDaemon(this.isDaemon());
        thread.setPriority(this.getThreadsPriority());
        thread.setName(this.getName() + "-" + thread.getId());
        return thread;
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        String string2 = this.getName() + "-";
        List list = Thread.getAllStackTraces().entrySet().stream().filter(entry -> ((Thread)entry.getKey()).getName().startsWith(string2)).map(entry -> {
            final Thread thread = (Thread)entry.getKey();
            final StackTraceElement[] stackTraceElementArray = (StackTraceElement[])entry.getValue();
            String string = null;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if ("getTask".equals(stackTraceElement.getMethodName()) && stackTraceElement.getClassName().endsWith("ThreadPoolExecutor")) {
                    string = "IDLE ";
                    break;
                }
                if ("reservedWait".equals(stackTraceElement.getMethodName()) && stackTraceElement.getClassName().endsWith("ReservedThread")) {
                    string = "RESERVED ";
                    break;
                }
                if ("select".equals(stackTraceElement.getMethodName()) && stackTraceElement.getClassName().endsWith("SelectorProducer")) {
                    string = "SELECTING ";
                    break;
                }
                if (!"accept".equals(stackTraceElement.getMethodName()) || !stackTraceElement.getClassName().contains("ServerConnector")) continue;
                string = "ACCEPTING ";
                break;
            }
            final String string2 = string == null ? "" : string;
            return new Dumpable(){

                @Override
                public void dump(Appendable appendable, String string) throws IOException {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(thread.getId()).append(" ").append(thread.getName()).append(" p=").append(thread.getPriority()).append(" ").append(string2).append(thread.getState().toString());
                    if (ExecutorThreadPool.this.isDetailedDump()) {
                        if (string2.isEmpty()) {
                            Dumpable.dumpObjects(appendable, string, stringBuilder.toString(), stackTraceElementArray);
                        } else {
                            Dumpable.dumpObject(appendable, stringBuilder.toString());
                        }
                    } else {
                        stringBuilder.append(" @ ").append(stackTraceElementArray.length > 0 ? String.valueOf(stackTraceElementArray[0]) : "<no_stack_frames>");
                        Dumpable.dumpObject(appendable, stringBuilder.toString());
                    }
                }

                @Override
                public String dump() {
                    return null;
                }
            };
        }).collect(Collectors.toList());
        List list2 = Collections.emptyList();
        if (this.isDetailedDump()) {
            list2 = new ArrayList<Runnable>(this._executor.getQueue());
        }
        this.dumpObjects(appendable, string, list, new DumpableCollection("jobs", list2));
    }

    @Override
    public String toString() {
        return String.format("%s[%s]@%x{%s,%d<=%d<=%d,i=%d,q=%d,%s}", this.getClass().getSimpleName(), this.getName(), this.hashCode(), this.getState(), this.getMinThreads(), this.getThreads(), this.getMaxThreads(), this.getIdleThreads(), this._executor.getQueue().size(), this._tryExecutor);
    }
}

