/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.statistic;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class RateStatistic {
    private final Deque<Long> _samples = new ArrayDeque<Long>();
    private final long _nanoPeriod;
    private final TimeUnit _units;
    private long _max;
    private long _count;

    public RateStatistic(long l, TimeUnit timeUnit) {
        this._nanoPeriod = TimeUnit.NANOSECONDS.convert(l, timeUnit);
        this._units = timeUnit;
    }

    public long getPeriod() {
        return this._units.convert(this._nanoPeriod, TimeUnit.NANOSECONDS);
    }

    public TimeUnit getUnits() {
        return this._units;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            this._samples.clear();
            this._max = 0L;
            this._count = 0L;
        }
    }

    private void update() {
        this.update(System.nanoTime());
    }

    private void update(long l) {
        long l2 = l - this._nanoPeriod;
        Long l3 = this._samples.peekFirst();
        while (l3 != null && l3 < l2) {
            this._samples.removeFirst();
            l3 = this._samples.peekFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void age(long l, TimeUnit timeUnit) {
        long l2 = TimeUnit.NANOSECONDS.convert(l, timeUnit);
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            int n = this._samples.size();
            for (int i = 0; i < n; ++i) {
                this._samples.addLast(this._samples.removeFirst() - l2);
            }
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int record() {
        long l = System.nanoTime();
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            ++this._count;
            this._samples.add(l);
            this.update(l);
            int n = this._samples.size();
            if ((long)n > this._max) {
                this._max = n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRate() {
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            this.update();
            return this._samples.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMax() {
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            return this._max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOldest(TimeUnit timeUnit) {
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            Long l = this._samples.peekFirst();
            if (l == null) {
                return -1L;
            }
            return timeUnit.convert(System.nanoTime() - l, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCount() {
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            return this._count;
        }
    }

    public String dump() {
        return this.dump(TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump(TimeUnit timeUnit) {
        long l = System.nanoTime();
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            String string = this._samples.stream().mapToLong(l2 -> timeUnit.convert(l - l2, TimeUnit.NANOSECONDS)).mapToObj(Long::toString).collect(Collectors.joining(System.lineSeparator()));
            return String.format("%s%n%s", this.toString(l), string);
        }
    }

    public String toString() {
        return this.toString(System.nanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(long l) {
        RateStatistic rateStatistic = this;
        synchronized (rateStatistic) {
            this.update(l);
            return String.format("%s@%x{count=%d,max=%d,rate=%d per %d %s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._count, this._max, this._samples.size(), this._units.convert(this._nanoPeriod, TimeUnit.NANOSECONDS), this._units});
        }
    }
}

