/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.Permission;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;

@Deprecated
public class FileResource
extends Resource {
    private static final Logger LOG = Log.getLogger(FileResource.class);
    private final File _file;
    private final URI _uri;
    private final URI _alias;

    public FileResource(URL uRL) throws IOException, URISyntaxException {
        File file;
        try {
            file = new File(uRL.toURI());
            this.assertValidPath(file.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw uRISyntaxException;
        }
        catch (Exception exception) {
            if (!uRL.toString().startsWith("file:")) {
                throw new IllegalArgumentException("!file:");
            }
            LOG.ignore(exception);
            try {
                String string = "file:" + URIUtil.encodePath(uRL.toString().substring(5));
                URI uRI = new URI(string);
                file = uRI.getAuthority() == null ? new File(uRI) : new File("//" + uRI.getAuthority() + URIUtil.decodePath(uRL.getFile()));
            }
            catch (Exception exception2) {
                LOG.ignore(exception2);
                URLConnection uRLConnection = uRL.openConnection();
                Permission permission = uRLConnection.getPermission();
                file = new File(permission == null ? uRL.getFile() : permission.getName());
            }
        }
        this._file = file;
        this._uri = FileResource.normalizeURI(this._file, uRL.toURI());
        this._alias = FileResource.checkFileAlias(this._uri, this._file);
    }

    public FileResource(URI uRI) {
        File file;
        this._file = file = new File(uRI);
        try {
            URI uRI2 = this._file.toURI();
            this._uri = FileResource.normalizeURI(this._file, uRI);
            this.assertValidPath(file.toString());
            this._alias = !URIUtil.equalsIgnoreEncodings(this._uri.toASCIIString(), uRI2.toString()) ? this._file.toURI() : FileResource.checkFileAlias(this._uri, this._file);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidPathException(this._file.toString(), uRISyntaxException.getMessage()){
                {
                    super(string, string2);
                    this.initCause(uRISyntaxException);
                }
            };
        }
    }

    public FileResource(File file) {
        this.assertValidPath(file.toString());
        this._file = file;
        try {
            this._uri = FileResource.normalizeURI(this._file, this._file.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidPathException(this._file.toString(), uRISyntaxException.getMessage()){
                {
                    super(string, string2);
                    this.initCause(uRISyntaxException);
                }
            };
        }
        this._alias = FileResource.checkFileAlias(this._uri, this._file);
    }

    public FileResource(File file, String string) {
        URI uRI;
        String string2 = URIUtil.encodePath(string);
        this._file = new File(file, string);
        try {
            uRI = file.isDirectory() ? new URI(URIUtil.addEncodedPaths(file.toURI().toASCIIString(), string2)) : new URI(file.toURI().toASCIIString() + string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidPathException(file.toString() + string, uRISyntaxException.getMessage()){
                {
                    super(string, string2);
                    this.initCause(uRISyntaxException);
                }
            };
        }
        this._uri = uRI;
        this._alias = FileResource.checkFileAlias(this._uri, this._file);
    }

    @Override
    public boolean isSame(Resource resource) {
        block4: {
            try {
                if (resource instanceof PathResource) {
                    Path path = ((PathResource)resource).getPath();
                    return Files.isSameFile(this.getFile().toPath(), path);
                }
                if (resource instanceof FileResource) {
                    Path path = ((FileResource)resource).getFile().toPath();
                    return Files.isSameFile(this.getFile().toPath(), path);
                }
            }
            catch (IOException iOException) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("ignored", iOException);
            }
        }
        return false;
    }

    private static URI normalizeURI(File file, URI uRI) throws URISyntaxException {
        String string = uRI.toASCIIString();
        if (file.isDirectory()) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
        } else if (file.exists() && string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return new URI(string);
    }

    private static URI checkFileAlias(URI uRI, File file) {
        try {
            String string;
            if (!URIUtil.equalsIgnoreEncodings(uRI, file.toURI())) {
                return new File(uRI).getAbsoluteFile().toURI();
            }
            String string2 = file.getAbsolutePath();
            if (!string2.equals(string = file.getCanonicalPath())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ALIAS abs={} can={}", string2, string);
                }
                URI uRI2 = new File(string).toURI();
                return new URI("file://" + URIUtil.encodePath(uRI2.getPath()));
            }
        }
        catch (Exception exception) {
            LOG.warn("bad alias for {}: {}", file, exception.toString());
            LOG.debug(exception);
            try {
                return new URI("https://eclipse.org/bad/canonical/alias");
            }
            catch (Exception exception2) {
                LOG.ignore(exception2);
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    @Override
    public Resource addPath(String string) throws IOException {
        this.assertValidPath(string);
        if (URIUtil.canonicalPath(string) == null) {
            throw new MalformedURLException(string);
        }
        if ("/".equals(string)) {
            return this;
        }
        return new FileResource(this._file, string);
    }

    private void assertValidPath(String string) {
        int n = StringUtil.indexOfControlChars(string);
        if (n >= 0) {
            throw new InvalidPathException(string, "Invalid Character at index " + n);
        }
    }

    @Override
    public URI getAlias() {
        return this._alias;
    }

    @Override
    public boolean exists() {
        return this._file.exists();
    }

    @Override
    public long lastModified() {
        return this._file.lastModified();
    }

    @Override
    public boolean isDirectory() {
        return this._file.exists() && this._file.isDirectory() || this._uri.toASCIIString().endsWith("/");
    }

    @Override
    public long length() {
        return this._file.length();
    }

    @Override
    public String getName() {
        return this._file.getAbsolutePath();
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return FileChannel.open(this._file.toPath(), StandardOpenOption.READ);
    }

    @Override
    public boolean delete() throws SecurityException {
        return this._file.delete();
    }

    @Override
    public boolean renameTo(Resource resource) throws SecurityException {
        if (resource instanceof FileResource) {
            return this._file.renameTo(((FileResource)resource)._file);
        }
        return false;
    }

    @Override
    public String[] list() {
        String[] stringArray = this._file.list();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        while (n-- > 0) {
            if (!new File(this._file, stringArray[n]).isDirectory() || stringArray[n].endsWith("/")) continue;
            int n2 = n;
            stringArray[n2] = stringArray[n2] + "/";
        }
        return stringArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object || !(object instanceof FileResource)) {
            return false;
        }
        FileResource fileResource = (FileResource)object;
        return fileResource._file == this._file || null != this._file && this._file.equals(fileResource._file);
    }

    public int hashCode() {
        return null == this._file ? super.hashCode() : this._file.hashCode();
    }

    @Override
    public void copyTo(File file) throws IOException {
        if (this.isDirectory()) {
            IO.copyDir(this.getFile(), file);
        } else {
            if (file.exists()) {
                throw new IllegalArgumentException(file + " exists");
            }
            IO.copy(this.getFile(), file);
        }
    }

    @Override
    public boolean isContainedIn(Resource resource) throws MalformedURLException {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public URL getURL() {
        try {
            return this._uri.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException);
        }
    }

    @Override
    public URI getURI() {
        return this._uri;
    }

    public String toString() {
        return this._uri.toString();
    }
}

