/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.compression;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public abstract class CompressionPool<T>
extends AbstractLifeCycle {
    public static final int INFINITE_CAPACITY = -1;
    private final Queue<T> _pool;
    private final AtomicInteger _numObjects = new AtomicInteger(0);
    private final int _capacity;

    public CompressionPool(int n) {
        this._capacity = n;
        this._pool = this._capacity == 0 ? null : new ConcurrentLinkedQueue();
    }

    protected abstract T newObject();

    protected abstract void end(T var1);

    protected abstract void reset(T var1);

    public T acquire() {
        T t;
        if (this._capacity == 0) {
            t = this.newObject();
        } else {
            t = this._pool.poll();
            if (t == null) {
                t = this.newObject();
            } else if (this._capacity > 0) {
                this._numObjects.decrementAndGet();
            }
        }
        return t;
    }

    public void release(T t) {
        block5: {
            if (t == null) {
                return;
            }
            if (this._capacity == 0 || !this.isRunning()) {
                this.end(t);
                return;
            }
            if (this._capacity < 0) {
                this.reset(t);
                this._pool.add(t);
            } else {
                int n;
                do {
                    if ((n = this._numObjects.get()) < this._capacity) continue;
                    this.end(t);
                    break block5;
                } while (!this._numObjects.compareAndSet(n, n + 1));
                this.reset(t);
                this._pool.add(t);
            }
        }
    }

    @Override
    public void doStop() {
        T t = this._pool.poll();
        while (t != null) {
            this.end(t);
            t = this._pool.poll();
        }
        this._numObjects.set(0);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append('@').append(Integer.toHexString(this.hashCode()));
        stringBuilder.append('{').append(this.getState());
        stringBuilder.append(",size=").append(this._pool == null ? -1 : this._pool.size());
        stringBuilder.append(",capacity=").append(this._capacity <= 0 ? "UNLIMITED" : Integer.valueOf(this._capacity));
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

