/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jetty.util.component.Dumpable;

public class DumpableCollection
implements Dumpable {
    private final String _name;
    private final Collection<?> _collection;

    public DumpableCollection(String string, Collection<?> collection) {
        this._name = string;
        this._collection = collection;
    }

    public static DumpableCollection fromArray(String string, Object[] objectArray) {
        return new DumpableCollection(string, objectArray == null ? Collections.emptyList() : Arrays.asList(objectArray));
    }

    public static DumpableCollection from(String string, Object ... objectArray) {
        return new DumpableCollection(string, objectArray == null ? Collections.emptyList() : Arrays.asList(objectArray));
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        Object[] objectArray = this._collection == null ? null : this._collection.toArray();
        Dumpable.dumpObjects(appendable, string, this._name + " size=" + (objectArray == null ? 0 : objectArray.length), objectArray);
    }
}

