/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;

@ManagedObject(value="Dumpable Object")
public interface Dumpable {
    public static final String KEY = "key: +- bean, += managed, +~ unmanaged, +? auto, +: iterable, +] array, +@ map, +> undefined";

    @ManagedOperation(value="Dump the nested Object state as a String", impact="INFO")
    default public String dump() {
        return Dumpable.dump(this);
    }

    public void dump(Appendable var1, String var2) throws IOException;

    public static String dump(Dumpable dumpable) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            dumpable.dump(stringBuilder, "");
        }
        catch (IOException iOException) {
            stringBuilder.append(iOException.toString());
        }
        stringBuilder.append(KEY);
        return stringBuilder.toString();
    }

    default public String dumpSelf() {
        return this.toString();
    }

    public static void dumpObject(Appendable appendable, Object object) throws IOException {
        try {
            String string;
            if (object == null) {
                string = "null";
            } else if (object instanceof Dumpable) {
                string = ((Dumpable)object).dumpSelf();
                string = StringUtil.replace(string, "\r\n", "|");
                string = StringUtil.replace(string, '\n', '|');
            } else if (object instanceof Collection) {
                string = String.format("%s@%x(size=%d)", object.getClass().getName(), object.hashCode(), ((Collection)object).size());
            } else if (object.getClass().isArray()) {
                string = String.format("%s@%x[size=%d]", object.getClass().getComponentType(), object.hashCode(), Array.getLength(object));
            } else if (object instanceof Map) {
                string = String.format("%s@%x{size=%d}", object.getClass().getName(), object.hashCode(), ((Map)object).size());
            } else {
                string = String.valueOf(object);
                string = StringUtil.replace(string, "\r\n", "|");
                string = StringUtil.replace(string, '\n', '|');
            }
            if (object instanceof LifeCycle) {
                appendable.append(string).append(" - ").append(AbstractLifeCycle.getState((LifeCycle)object)).append("\n");
            } else {
                appendable.append(string).append("\n");
            }
        }
        catch (Throwable throwable) {
            appendable.append("=> ").append(throwable.toString()).append("\n");
        }
    }

    public static void dumpObjects(Appendable appendable, String string, Object object, Object ... objectArray) throws IOException {
        int n;
        Dumpable.dumpObject(appendable, object);
        int n2 = n = objectArray == null ? 0 : objectArray.length;
        if (object instanceof Stream) {
            object = ((Stream)object).toArray();
        }
        if (object instanceof Array) {
            object = Arrays.asList(object);
        }
        if (object instanceof Container) {
            Dumpable.dumpContainer(appendable, string, (Container)object, n == 0);
        }
        if (object instanceof Iterable) {
            Dumpable.dumpIterable(appendable, string, (Iterable)object, n == 0);
        } else if (object instanceof Map) {
            Dumpable.dumpMapEntries(appendable, string, (Map)object, n == 0);
        }
        if (n == 0) {
            return;
        }
        int n3 = 0;
        for (Object object2 : objectArray) {
            String string2 = string + (++n3 < n ? "|  " : "   ");
            appendable.append(string).append("+> ");
            if (object2 instanceof Dumpable) {
                ((Dumpable)object2).dump(appendable, string2);
                continue;
            }
            Dumpable.dumpObjects(appendable, string2, object2, new Object[0]);
        }
    }

    public static void dumpContainer(Appendable appendable, String string, Container container, boolean bl) throws IOException {
        Container container2 = container;
        ContainerLifeCycle containerLifeCycle = container2 instanceof ContainerLifeCycle ? (ContainerLifeCycle)container2 : null;
        Iterator<Object> iterator = container2.getBeans().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (container2 instanceof DumpableContainer && !((DumpableContainer)((Object)container2)).isDumpable(object)) continue;
            String string2 = string + (iterator.hasNext() || !bl ? "|  " : "   ");
            if (object instanceof LifeCycle) {
                if (container2.isManaged(object)) {
                    appendable.append(string).append("+= ");
                    if (object instanceof Dumpable) {
                        ((Dumpable)object).dump(appendable, string2);
                        continue;
                    }
                    Dumpable.dumpObjects(appendable, string2, object, new Object[0]);
                    continue;
                }
                if (containerLifeCycle != null && containerLifeCycle.isAuto(object)) {
                    appendable.append(string).append("+? ");
                    if (object instanceof Dumpable) {
                        ((Dumpable)object).dump(appendable, string2);
                        continue;
                    }
                    Dumpable.dumpObjects(appendable, string2, object, new Object[0]);
                    continue;
                }
                appendable.append(string).append("+~ ");
                Dumpable.dumpObject(appendable, object);
                continue;
            }
            if (containerLifeCycle != null && containerLifeCycle.isUnmanaged(object)) {
                appendable.append(string).append("+~ ");
                Dumpable.dumpObject(appendable, object);
                continue;
            }
            appendable.append(string).append("+- ");
            if (object instanceof Dumpable) {
                ((Dumpable)object).dump(appendable, string2);
                continue;
            }
            Dumpable.dumpObjects(appendable, string2, object, new Object[0]);
        }
    }

    public static void dumpIterable(Appendable appendable, String string, Iterable<?> iterable, boolean bl) throws IOException {
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            String string2 = string + (iterator.hasNext() || !bl ? "|  " : "   ");
            appendable.append(string).append("+: ");
            if (obj instanceof Dumpable) {
                ((Dumpable)obj).dump(appendable, string2);
                continue;
            }
            Dumpable.dumpObjects(appendable, string2, obj, new Object[0]);
        }
    }

    public static void dumpMapEntries(Appendable appendable, String string, Map<?, ?> map, boolean bl) throws IOException {
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            String string2 = string + (iterator.hasNext() || !bl ? "|  " : "   ");
            appendable.append(string).append("+@ ").append(String.valueOf(entry.getKey())).append(" = ");
            Object obj = entry.getValue();
            if (obj instanceof Dumpable) {
                ((Dumpable)obj).dump(appendable, string2);
                continue;
            }
            Dumpable.dumpObjects(appendable, string2, obj, new Object[0]);
        }
    }

    public static Dumpable named(String string, Object object) {
        return (appendable, string2) -> {
            appendable.append(string).append(": ");
            Dumpable.dumpObjects(appendable, string2, object, new Object[0]);
        };
    }

    public static interface DumpableContainer
    extends Dumpable {
        default public boolean isDumpable(Object object) {
            return true;
        }
    }
}

