/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.Utf8StringBuilder;

public class Utf8LineParser {
    private State state = State.START;
    private Utf8StringBuilder utf;

    public String parse(ByteBuffer byteBuffer) {
        while (byteBuffer.remaining() > 0) {
            byte by = byteBuffer.get();
            if (!this.parseByte(by)) continue;
            this.state = State.START;
            return this.utf.toString();
        }
        return null;
    }

    private boolean parseByte(byte by) {
        switch (this.state) {
            case START: {
                this.utf = new Utf8StringBuilder();
                this.state = State.PARSE;
                return this.parseByte(by);
            }
            case PARSE: {
                if (this.utf.isUtf8SequenceComplete() && (by == 13 || by == 10)) {
                    this.state = State.END;
                    return this.parseByte(by);
                }
                this.utf.append(by);
                break;
            }
            case END: {
                if (by != 10) break;
                this.state = State.START;
                return true;
            }
        }
        return false;
    }

    private static enum State {
        START,
        PARSE,
        END;

    }
}

