/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.jetty.util.TypeUtil;

public class QuotedStringTokenizer
extends StringTokenizer {
    private static final String __delim = "\t\n\r";
    private String _string;
    private String _delim = "\t\n\r";
    private boolean _returnQuotes = false;
    private boolean _returnDelimiters = false;
    private StringBuffer _token;
    private boolean _hasToken = false;
    private int _i = 0;
    private int _lastStart = 0;
    private boolean _double = true;
    private boolean _single = true;
    private static final char[] escapes = new char[32];

    public QuotedStringTokenizer(String string, String string2, boolean bl, boolean bl2) {
        super("");
        this._string = string;
        if (string2 != null) {
            this._delim = string2;
        }
        this._returnDelimiters = bl;
        this._returnQuotes = bl2;
        if (this._delim.indexOf(39) >= 0 || this._delim.indexOf(34) >= 0) {
            throw new Error("Can't use quotes as delimiters: " + this._delim);
        }
        this._token = new StringBuffer(this._string.length() > 1024 ? 512 : this._string.length() / 2);
    }

    public QuotedStringTokenizer(String string, String string2, boolean bl) {
        this(string, string2, bl, false);
    }

    public QuotedStringTokenizer(String string, String string2) {
        this(string, string2, false, false);
    }

    public QuotedStringTokenizer(String string) {
        this(string, null, false, false);
    }

    @Override
    public boolean hasMoreTokens() {
        if (this._hasToken) {
            return true;
        }
        this._lastStart = this._i;
        int n = 0;
        boolean bl = false;
        while (this._i < this._string.length()) {
            char c = this._string.charAt(this._i++);
            switch (n) {
                case 0: {
                    if (this._delim.indexOf(c) >= 0) {
                        if (!this._returnDelimiters) break;
                        this._token.append(c);
                        this._hasToken = true;
                        return true;
                    }
                    if (c == '\'' && this._single) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 2;
                        break;
                    }
                    if (c == '\"' && this._double) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 3;
                        break;
                    }
                    this._token.append(c);
                    this._hasToken = true;
                    n = 1;
                    break;
                }
                case 1: {
                    this._hasToken = true;
                    if (this._delim.indexOf(c) >= 0) {
                        if (this._returnDelimiters) {
                            --this._i;
                        }
                        return this._hasToken;
                    }
                    if (c == '\'' && this._single) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 2;
                        break;
                    }
                    if (c == '\"' && this._double) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 3;
                        break;
                    }
                    this._token.append(c);
                    break;
                }
                case 2: {
                    this._hasToken = true;
                    if (bl) {
                        bl = false;
                        this._token.append(c);
                        break;
                    }
                    if (c == '\'') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 1;
                        break;
                    }
                    if (c == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        bl = true;
                        break;
                    }
                    this._token.append(c);
                    break;
                }
                case 3: {
                    this._hasToken = true;
                    if (bl) {
                        bl = false;
                        this._token.append(c);
                        break;
                    }
                    if (c == '\"') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        n = 1;
                        break;
                    }
                    if (c == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        bl = true;
                        break;
                    }
                    this._token.append(c);
                }
            }
        }
        return this._hasToken;
    }

    @Override
    public String nextToken() throws NoSuchElementException {
        if (!this.hasMoreTokens() || this._token == null) {
            throw new NoSuchElementException();
        }
        String string = this._token.toString();
        this._token.setLength(0);
        this._hasToken = false;
        return string;
    }

    @Override
    public String nextToken(String string) throws NoSuchElementException {
        this._delim = string;
        this._i = this._lastStart;
        this._token.setLength(0);
        this._hasToken = false;
        return this.nextToken();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    @Override
    public Object nextElement() throws NoSuchElementException {
        return this.nextToken();
    }

    @Override
    public int countTokens() {
        return -1;
    }

    public static String quoteIfNeeded(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "\"\"";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\\' && c != '\"' && c != '\'' && !Character.isWhitespace(c) && string2.indexOf(c) < 0) continue;
            StringBuffer stringBuffer = new StringBuffer(string.length() + 8);
            QuotedStringTokenizer.quote(stringBuffer, string);
            return stringBuffer.toString();
        }
        return string;
    }

    public static String quote(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "\"\"";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 8);
        QuotedStringTokenizer.quote(stringBuffer, string);
        return stringBuffer.toString();
    }

    public static void quoteOnly(Appendable appendable, String string) {
        if (string == null) {
            return;
        }
        try {
            appendable.append('\"');
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\"' || c == '\\') {
                    appendable.append('\\');
                }
                appendable.append(c);
            }
            appendable.append('\"');
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void quote(Appendable appendable, String string) {
        if (string == null) {
            return;
        }
        try {
            appendable.append('\"');
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c >= ' ') {
                    if (c == '\"' || c == '\\') {
                        appendable.append('\\');
                    }
                    appendable.append(c);
                    continue;
                }
                char c2 = escapes[c];
                if (c2 == '\uffff') {
                    appendable.append('\\').append('u').append('0').append('0');
                    if (c < '\u0010') {
                        appendable.append('0');
                    }
                    appendable.append(Integer.toString(c, 16));
                    continue;
                }
                appendable.append('\\').append(c2);
            }
            appendable.append('\"');
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String unquoteOnly(String string) {
        return QuotedStringTokenizer.unquoteOnly(string, false);
    }

    public static String unquoteOnly(String string, boolean bl) {
        char c;
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return string;
        }
        char c2 = string.charAt(0);
        if (c2 != (c = string.charAt(string.length() - 1)) || c2 != '\"' && c2 != '\'') {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() - 2);
        boolean bl2 = false;
        for (int i = 1; i < string.length() - 1; ++i) {
            char c3 = string.charAt(i);
            if (bl2) {
                bl2 = false;
                if (bl && !QuotedStringTokenizer.isValidEscaping(c3)) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c3);
                continue;
            }
            if (c3 == '\\') {
                bl2 = true;
                continue;
            }
            stringBuilder.append(c3);
        }
        return stringBuilder.toString();
    }

    public static String unquote(String string) {
        return QuotedStringTokenizer.unquote(string, false);
    }

    public static String unquote(String string, boolean bl) {
        char c;
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return string;
        }
        char c2 = string.charAt(0);
        if (c2 != (c = string.charAt(string.length() - 1)) || c2 != '\"' && c2 != '\'') {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() - 2);
        boolean bl2 = false;
        for (int i = 1; i < string.length() - 1; ++i) {
            char c3 = string.charAt(i);
            if (bl2) {
                bl2 = false;
                switch (c3) {
                    case 'n': {
                        stringBuilder.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuilder.append('\t');
                        break;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        break;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        break;
                    }
                    case '\\': {
                        stringBuilder.append('\\');
                        break;
                    }
                    case '/': {
                        stringBuilder.append('/');
                        break;
                    }
                    case '\"': {
                        stringBuilder.append('\"');
                        break;
                    }
                    case 'u': {
                        stringBuilder.append((char)((TypeUtil.convertHexDigit((byte)string.charAt(i++)) << 24) + (TypeUtil.convertHexDigit((byte)string.charAt(i++)) << 16) + (TypeUtil.convertHexDigit((byte)string.charAt(i++)) << 8) + TypeUtil.convertHexDigit((byte)string.charAt(i++))));
                        break;
                    }
                    default: {
                        if (bl && !QuotedStringTokenizer.isValidEscaping(c3)) {
                            stringBuilder.append('\\');
                        }
                        stringBuilder.append(c3);
                        break;
                    }
                }
                continue;
            }
            if (c3 == '\\') {
                bl2 = true;
                continue;
            }
            stringBuilder.append(c3);
        }
        return stringBuilder.toString();
    }

    private static boolean isValidEscaping(char c) {
        return c == 'n' || c == 'r' || c == 't' || c == 'f' || c == 'b' || c == '\\' || c == '/' || c == '\"' || c == 'u';
    }

    public static boolean isQuoted(String string) {
        return string != null && string.length() > 0 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"';
    }

    public boolean getDouble() {
        return this._double;
    }

    public void setDouble(boolean bl) {
        this._double = bl;
    }

    public boolean getSingle() {
        return this._single;
    }

    public void setSingle(boolean bl) {
        this._single = bl;
    }

    static {
        Arrays.fill(escapes, '\uffff');
        QuotedStringTokenizer.escapes[8] = 98;
        QuotedStringTokenizer.escapes[9] = 116;
        QuotedStringTokenizer.escapes[10] = 110;
        QuotedStringTokenizer.escapes[12] = 102;
        QuotedStringTokenizer.escapes[13] = 114;
    }
}

