/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

public class ProcessorUtils {
    public static final String AVAILABLE_PROCESSORS = "JETTY_AVAILABLE_PROCESSORS";
    private static int __availableProcessors = ProcessorUtils.init();

    static int init() {
        String string = System.getProperty(AVAILABLE_PROCESSORS, System.getenv(AVAILABLE_PROCESSORS));
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Runtime.getRuntime().availableProcessors();
    }

    public static int availableProcessors() {
        return __availableProcessors;
    }

    public static void setAvailableProcessors(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid number of processors: " + n);
        }
        __availableProcessors = n;
    }
}

