/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;

public class LogarithmicArrayByteBufferPool
extends ArrayByteBufferPool {
    public LogarithmicArrayByteBufferPool() {
        this(-1, -1, -1);
    }

    public LogarithmicArrayByteBufferPool(int n, int n2) {
        this(n, n2, -1, -1L, -1L);
    }

    public LogarithmicArrayByteBufferPool(int n, int n2, int n3) {
        this(n, n2, n3, -1L, -1L);
    }

    public LogarithmicArrayByteBufferPool(int n, int n2, int n3, long l, long l2) {
        super(n, 1, n2, n3, l, l2);
    }

    @Override
    protected int bucketFor(int n) {
        return 32 - Integer.numberOfLeadingZeros(n - 1);
    }

    @Override
    protected int capacityFor(int n) {
        return 1 << n;
    }

    @Override
    protected void releaseMemory(boolean bl) {
        long l = Long.MAX_VALUE;
        int n = -1;
        ByteBufferPool.Bucket[] bucketArray = this.bucketsFor(bl);
        for (int i = 0; i < bucketArray.length; ++i) {
            long l2;
            ByteBufferPool.Bucket bucket = bucketArray[i];
            if (bucket.isEmpty() || (l2 = bucket.getLastUpdate()) >= l) continue;
            l = l2;
            n = i;
        }
        if (n >= 0) {
            ByteBufferPool.Bucket bucket = bucketArray[n];
            bucket.acquire();
            bucket.resetUpdateTime();
        }
    }
}

