/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class CyclicTimeout
implements Destroyable {
    private static final Logger LOG = Log.getLogger(CyclicTimeout.class);
    private static final Timeout NOT_SET = new Timeout(Long.MAX_VALUE, null);
    private static final Scheduler.Task DESTROYED = () -> false;
    private final Scheduler _scheduler;
    private final AtomicReference<Timeout> _timeout = new AtomicReference<Timeout>(NOT_SET);

    public CyclicTimeout(Scheduler scheduler) {
        this._scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this._scheduler;
    }

    public boolean schedule(long l, TimeUnit timeUnit) {
        boolean bl;
        Wakeup wakeup;
        Timeout timeout;
        long l2 = System.nanoTime();
        long l3 = l2 + timeUnit.toNanos(l);
        Wakeup wakeup2 = null;
        do {
            bl = (timeout = this._timeout.get())._at != Long.MAX_VALUE;
            wakeup = timeout._wakeup;
            if (wakeup != null && wakeup._at <= l3) continue;
            wakeup = wakeup2 = new Wakeup(l3, wakeup);
        } while (!this._timeout.compareAndSet(timeout, new Timeout(l3, wakeup)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Installed timeout in {} ms, {} wake up in {} ms", timeUnit.toMillis(l), wakeup2 != null ? "new" : "existing", TimeUnit.NANOSECONDS.toMillis(wakeup._at - l2));
        }
        if (wakeup2 != null) {
            wakeup2.schedule(l2);
        }
        return bl;
    }

    public boolean cancel() {
        boolean bl;
        Wakeup wakeup;
        Timeout timeout;
        Timeout timeout2;
        do {
            bl = (timeout2 = this._timeout.get())._at != Long.MAX_VALUE;
        } while (!this._timeout.compareAndSet(timeout2, timeout = (wakeup = timeout2._wakeup) == null ? NOT_SET : new Timeout(Long.MAX_VALUE, wakeup)));
        return bl;
    }

    public abstract void onTimeoutExpired();

    @Override
    public void destroy() {
        Wakeup wakeup;
        Timeout timeout = this._timeout.getAndSet(NOT_SET);
        Wakeup wakeup2 = wakeup = timeout == null ? null : timeout._wakeup;
        while (wakeup != null) {
            wakeup.destroy();
            wakeup = wakeup._next;
        }
    }

    private class Wakeup
    implements Runnable {
        private final AtomicReference<Scheduler.Task> _task = new AtomicReference();
        private final long _at;
        private final Wakeup _next;

        private Wakeup(long l, Wakeup wakeup) {
            this._at = l;
            this._next = wakeup;
        }

        private void schedule(long l) {
            this._task.compareAndSet(null, CyclicTimeout.this._scheduler.schedule(this, this._at - l, TimeUnit.NANOSECONDS));
        }

        private void destroy() {
            Scheduler.Task task = this._task.getAndSet(DESTROYED);
            if (task != null) {
                task.cancel();
            }
        }

        @Override
        public void run() {
            Timeout timeout;
            Timeout timeout2;
            long l = System.nanoTime();
            Wakeup wakeup = null;
            boolean bl = false;
            do {
                timeout2 = (Timeout)CyclicTimeout.this._timeout.get();
                Wakeup wakeup2 = timeout2._wakeup;
                while (wakeup2 != null && wakeup2 != this) {
                    wakeup2 = wakeup2._next;
                }
                if (wakeup2 == null) {
                    return;
                }
                wakeup2 = wakeup2._next;
                if (timeout2._at <= l) {
                    bl = true;
                    timeout = wakeup2 == null ? NOT_SET : new Timeout(Long.MAX_VALUE, wakeup2);
                    continue;
                }
                if (timeout2._at != Long.MAX_VALUE) {
                    if (wakeup2 == null || wakeup2._at >= timeout2._at) {
                        wakeup2 = wakeup = new Wakeup(timeout2._at, wakeup2);
                    }
                    timeout = new Timeout(timeout2._at, wakeup2);
                    continue;
                }
                Timeout timeout3 = timeout = wakeup2 == null ? NOT_SET : new Timeout(Long.MAX_VALUE, wakeup2);
            } while (!CyclicTimeout.this._timeout.compareAndSet(timeout2, timeout));
            if (wakeup != null) {
                wakeup.schedule(l);
            }
            if (bl) {
                CyclicTimeout.this.onTimeoutExpired();
            }
        }

        public String toString() {
            return String.format("%s@%x:%dms->%s", this.getClass().getSimpleName(), this.hashCode(), this._at == Long.MAX_VALUE ? this._at : TimeUnit.NANOSECONDS.toMillis(this._at - System.nanoTime()), this._next);
        }
    }

    private static class Timeout {
        private final long _at;
        private final Wakeup _wakeup;

        private Timeout(long l, Wakeup wakeup) {
            this._at = l;
            this._wakeup = wakeup;
        }

        public String toString() {
            return String.format("%s@%x:%dms,%s", this.getClass().getSimpleName(), this.hashCode(), TimeUnit.NANOSECONDS.toMillis(this._at - System.nanoTime()), this._wakeup);
        }
    }
}

