/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.EOFException;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.Scheduler;

public class ByteArrayEndPoint
extends AbstractEndPoint {
    static final Logger LOG = Log.getLogger(ByteArrayEndPoint.class);
    static final InetAddress NOIP;
    static final InetSocketAddress NOIPPORT;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFBFF;
    private static final ByteBuffer EOF;
    private final Runnable _runFillable = new Runnable(){

        @Override
        public void run() {
            ByteArrayEndPoint.this.getFillInterest().fillable();
        }
    };
    private final Locker _locker = new Locker();
    private final Condition _hasOutput = this._locker.newCondition();
    private final Queue<ByteBuffer> _inQ = new ArrayDeque<ByteBuffer>();
    private final int _outputSize;
    private ByteBuffer _out;
    private boolean _growOutput;

    public ByteArrayEndPoint() {
        this(null, 0L, null, null);
    }

    public ByteArrayEndPoint(byte[] byArray, int n) {
        this(null, 0L, byArray != null ? BufferUtil.toBuffer(byArray) : null, BufferUtil.allocate(n));
    }

    public ByteArrayEndPoint(String string, int n) {
        this(null, 0L, string != null ? BufferUtil.toBuffer(string) : null, BufferUtil.allocate(n));
    }

    public ByteArrayEndPoint(Scheduler scheduler, long l) {
        this(scheduler, l, null, null);
    }

    public ByteArrayEndPoint(Scheduler scheduler, long l, byte[] byArray, int n) {
        this(scheduler, l, byArray != null ? BufferUtil.toBuffer(byArray) : null, BufferUtil.allocate(n));
    }

    public ByteArrayEndPoint(Scheduler scheduler, long l, String string, int n) {
        this(scheduler, l, string != null ? BufferUtil.toBuffer(string) : null, BufferUtil.allocate(n));
    }

    public ByteArrayEndPoint(Scheduler scheduler, long l, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        super(scheduler);
        if (BufferUtil.hasContent(byteBuffer)) {
            this.addInput(byteBuffer);
        }
        this._outputSize = byteBuffer2 == null ? 1024 : byteBuffer2.capacity();
        this._out = byteBuffer2 == null ? BufferUtil.allocate(this._outputSize) : byteBuffer2;
        this.setIdleTimeout(l);
        this.onOpen();
    }

    @Override
    public void doShutdownOutput() {
        super.doShutdownOutput();
        try (Locker.Lock lock = this._locker.lock();){
            this._hasOutput.signalAll();
        }
    }

    @Override
    public void doClose() {
        super.doClose();
        try (Locker.Lock lock = this._locker.lock();){
            this._hasOutput.signalAll();
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return NOIPPORT;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return NOIPPORT;
    }

    @Override
    protected void onIncompleteFlush() {
    }

    protected void execute(Runnable runnable) {
        new Thread(runnable, "BAEPoint-" + Integer.toHexString(this.hashCode())).start();
    }

    @Override
    protected void needsFillInterest() throws IOException {
        try (Locker.Lock lock = this._locker.lock();){
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            ByteBuffer byteBuffer = this._inQ.peek();
            if (BufferUtil.hasContent(byteBuffer) || ByteArrayEndPoint.isEOF(byteBuffer)) {
                this.execute(this._runFillable);
            }
        }
    }

    public void addInputEOF() {
        this.addInput((ByteBuffer)null);
    }

    public void addInput(ByteBuffer byteBuffer) {
        boolean bl = false;
        try (Locker.Lock lock = this._locker.lock();){
            if (ByteArrayEndPoint.isEOF(this._inQ.peek())) {
                throw new RuntimeIOException(new EOFException());
            }
            boolean bl2 = this._inQ.isEmpty();
            if (byteBuffer == null) {
                this._inQ.add(EOF);
                bl = true;
            }
            if (BufferUtil.hasContent(byteBuffer)) {
                this._inQ.add(byteBuffer);
                bl = bl2;
            }
        }
        if (bl) {
            this._runFillable.run();
        }
    }

    public void addInputAndExecute(ByteBuffer byteBuffer) {
        boolean bl = false;
        try (Locker.Lock lock = this._locker.lock();){
            if (ByteArrayEndPoint.isEOF(this._inQ.peek())) {
                throw new RuntimeIOException(new EOFException());
            }
            boolean bl2 = this._inQ.isEmpty();
            if (byteBuffer == null) {
                this._inQ.add(EOF);
                bl = true;
            }
            if (BufferUtil.hasContent(byteBuffer)) {
                this._inQ.add(byteBuffer);
                bl = bl2;
            }
        }
        if (bl) {
            this.execute(this._runFillable);
        }
    }

    public void addInput(String string) {
        this.addInput(BufferUtil.toBuffer(string, StandardCharsets.UTF_8));
    }

    public void addInput(String string, Charset charset) {
        this.addInput(BufferUtil.toBuffer(string, charset));
    }

    public ByteBuffer getOutput() {
        try (Locker.Lock lock = this._locker.lock();){
            ByteBuffer byteBuffer = this._out;
            return byteBuffer;
        }
    }

    public String getOutputString() {
        return this.getOutputString(StandardCharsets.UTF_8);
    }

    public String getOutputString(Charset charset) {
        return BufferUtil.toString(this._out, charset);
    }

    public ByteBuffer takeOutput() {
        ByteBuffer byteBuffer;
        try (Locker.Lock lock = this._locker.lock();){
            byteBuffer = this._out;
            this._out = BufferUtil.allocate(this._outputSize);
        }
        this.getWriteFlusher().completeWrite();
        return byteBuffer;
    }

    public ByteBuffer waitForOutput(long l, TimeUnit timeUnit) throws InterruptedException {
        ByteBuffer byteBuffer;
        try (Locker.Lock lock = this._locker.lock();){
            while (BufferUtil.isEmpty(this._out) && !this.isOutputShutdown()) {
                if (this._hasOutput.await(l, timeUnit)) continue;
                ByteBuffer byteBuffer2 = null;
                return byteBuffer2;
            }
            byteBuffer = this._out;
            this._out = BufferUtil.allocate(this._outputSize);
        }
        this.getWriteFlusher().completeWrite();
        return byteBuffer;
    }

    public String takeOutputString() {
        return this.takeOutputString(StandardCharsets.UTF_8);
    }

    public String takeOutputString(Charset charset) {
        ByteBuffer byteBuffer = this.takeOutput();
        return BufferUtil.toString(byteBuffer, charset);
    }

    public void setOutput(ByteBuffer byteBuffer) {
        try (Locker.Lock lock = this._locker.lock();){
            this._out = byteBuffer;
        }
        this.getWriteFlusher().completeWrite();
    }

    public boolean hasMore() {
        return this.getOutput().position() > 0;
    }

    @Override
    public int fill(ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        try (Locker.Lock lock = this._locker.lock();){
            while (true) {
                if (!this.isOpen()) {
                    throw new EofException("CLOSED");
                }
                if (this.isInputShutdown()) {
                    int n2 = -1;
                    return n2;
                }
                if (this._inQ.isEmpty()) {
                    break;
                }
                ByteBuffer byteBuffer2 = this._inQ.peek();
                if (ByteArrayEndPoint.isEOF(byteBuffer2)) {
                    n = -1;
                    break;
                }
                if (BufferUtil.hasContent(byteBuffer2)) {
                    n = BufferUtil.append(byteBuffer, byteBuffer2);
                    if (BufferUtil.isEmpty(byteBuffer2)) {
                        this._inQ.poll();
                    }
                    break;
                }
                this._inQ.poll();
            }
        }
        if (n > 0) {
            this.notIdle();
        } else if (n < 0) {
            this.shutdownInput();
        }
        return n;
    }

    @Override
    public boolean flush(ByteBuffer ... byteBufferArray) throws IOException {
        boolean bl = true;
        try (Locker.Lock lock = this._locker.lock();){
            if (!this.isOpen()) {
                throw new IOException("CLOSED");
            }
            if (this.isOutputShutdown()) {
                throw new IOException("OSHUT");
            }
            boolean bl2 = true;
            for (ByteBuffer byteBuffer : byteBufferArray) {
                if (!BufferUtil.hasContent(byteBuffer)) continue;
                if (this._growOutput && byteBuffer.remaining() > BufferUtil.space(this._out)) {
                    BufferUtil.compact(this._out);
                    if (byteBuffer.remaining() > BufferUtil.space(this._out) && this._out.capacity() < 0x7FFFFBFF) {
                        long l = Math.min((long)((double)this._out.capacity() + (double)byteBuffer.remaining() * 1.5), 0x7FFFFBFFL);
                        ByteBuffer byteBuffer2 = BufferUtil.allocate(Math.toIntExact(l));
                        BufferUtil.append(byteBuffer2, this._out);
                        this._out = byteBuffer2;
                    }
                }
                if (BufferUtil.append(this._out, byteBuffer) > 0) {
                    bl2 = false;
                }
                if (!BufferUtil.hasContent(byteBuffer)) continue;
                bl = false;
                break;
            }
            if (!bl2) {
                this.notIdle();
                this._hasOutput.signalAll();
            }
        }
        return bl;
    }

    @Override
    public void reset() {
        try (Locker.Lock lock = this._locker.lock();){
            this._inQ.clear();
            this._hasOutput.signalAll();
            BufferUtil.clear(this._out);
        }
        super.reset();
    }

    @Override
    public Object getTransport() {
        return null;
    }

    public boolean isGrowOutput() {
        return this._growOutput;
    }

    public void setGrowOutput(boolean bl) {
        this._growOutput = bl;
    }

    @Override
    public String toString() {
        String string;
        ByteBuffer byteBuffer;
        int n;
        try (Locker.Lock lock = this._locker.lock();){
            n = this._inQ.size();
            byteBuffer = this._inQ.peek();
            string = BufferUtil.toDetailString(this._out);
        }
        return String.format("%s[q=%d,q[0]=%s,o=%s]", super.toString(), n, byteBuffer, string);
    }

    private static boolean isEOF(ByteBuffer byteBuffer) {
        boolean bl = byteBuffer == EOF;
        return bl;
    }

    static {
        InetAddress inetAddress = null;
        try {
            inetAddress = Inet4Address.getByName("0.0.0.0");
        }
        catch (UnknownHostException unknownHostException) {
            LOG.warn(unknownHostException);
        }
        finally {
            NOIP = inetAddress;
            NOIPPORT = new InetSocketAddress(NOIP, 0);
        }
        EOF = BufferUtil.allocate(0);
    }
}

