/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;

@ManagedObject
abstract class AbstractByteBufferPool
implements ByteBufferPool {
    private final int _factor;
    private final int _maxQueueLength;
    private final long _maxHeapMemory;
    private final long _maxDirectMemory;
    private final AtomicLong _heapMemory = new AtomicLong();
    private final AtomicLong _directMemory = new AtomicLong();

    protected AbstractByteBufferPool(int n, int n2, long l, long l2) {
        this._factor = n <= 0 ? 1024 : n;
        this._maxQueueLength = n2;
        this._maxHeapMemory = l != 0L ? l : Runtime.getRuntime().maxMemory() / 4L;
        this._maxDirectMemory = l2 != 0L ? l2 : Runtime.getRuntime().maxMemory() / 4L;
    }

    protected int getCapacityFactor() {
        return this._factor;
    }

    protected int getMaxQueueLength() {
        return this._maxQueueLength;
    }

    @Deprecated
    protected void decrementMemory(ByteBuffer byteBuffer) {
        this.updateMemory(byteBuffer, false);
    }

    @Deprecated
    protected void incrementMemory(ByteBuffer byteBuffer) {
        this.updateMemory(byteBuffer, true);
    }

    private void updateMemory(ByteBuffer byteBuffer, boolean bl) {
        AtomicLong atomicLong = byteBuffer.isDirect() ? this._directMemory : this._heapMemory;
        int n = byteBuffer.capacity();
        atomicLong.addAndGet(bl ? (long)n : (long)(-n));
    }

    protected void releaseExcessMemory(boolean bl, Consumer<Boolean> consumer) {
        long l;
        long l2 = l = bl ? this._maxDirectMemory : this._maxHeapMemory;
        if (l > 0L) {
            while (this.getMemory(bl) > l) {
                consumer.accept(bl);
            }
        }
    }

    @ManagedAttribute(value="The bytes retained by direct ByteBuffers")
    public long getDirectMemory() {
        return this.getMemory(true);
    }

    @ManagedAttribute(value="The bytes retained by heap ByteBuffers")
    public long getHeapMemory() {
        return this.getMemory(false);
    }

    @ManagedAttribute(value="The max num of bytes that can be retained from direct ByteBuffers")
    public long getMaxDirectMemory() {
        return this._maxDirectMemory;
    }

    @ManagedAttribute(value="The max num of bytes that can be retained from heap ByteBuffers")
    public long getMaxHeapMemory() {
        return this._maxHeapMemory;
    }

    public long getMemory(boolean bl) {
        AtomicLong atomicLong = bl ? this._directMemory : this._heapMemory;
        return atomicLong.get();
    }

    IntConsumer updateMemory(boolean bl) {
        return bl ? this._directMemory::addAndGet : this._heapMemory::addAndGet;
    }

    @ManagedOperation(value="Clears this ByteBufferPool", impact="ACTION")
    public void clear() {
        this._heapMemory.set(0L);
        this._directMemory.set(0L);
    }
}

