/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class MimeTypes {
    private static final Logger LOG;
    private static final Trie<ByteBuffer> TYPES;
    private static final Map<String, String> __dftMimeMap;
    private static final Map<String, String> __inferredEncodings;
    private static final Map<String, String> __assumedEncodings;
    public static final Trie<Type> CACHE;
    private final Map<String, String> _mimeMap = new HashMap<String, String>();

    public synchronized Map<String, String> getMimeMap() {
        return this._mimeMap;
    }

    public void setMimeMap(Map<String, String> map) {
        this._mimeMap.clear();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this._mimeMap.put(StringUtil.asciiToLowerCase(entry.getKey()), MimeTypes.normalizeMimeType(entry.getValue()));
            }
        }
    }

    public static String getDefaultMimeByExtension(String string) {
        String string2 = null;
        if (string != null) {
            int n = -1;
            while (string2 == null && (n = string.indexOf(".", n + 1)) >= 0 && n < string.length()) {
                String string3 = StringUtil.asciiToLowerCase(string.substring(n + 1));
                if (string2 != null) continue;
                string2 = __dftMimeMap.get(string3);
            }
        }
        if (string2 == null) {
            string2 = __dftMimeMap.get("*");
        }
        return string2;
    }

    public String getMimeByExtension(String string) {
        String string2 = null;
        if (string != null) {
            int n = -1;
            while (string2 == null && (n = string.indexOf(".", n + 1)) >= 0 && n < string.length()) {
                String string3 = StringUtil.asciiToLowerCase(string.substring(n + 1));
                if (this._mimeMap != null) {
                    string2 = this._mimeMap.get(string3);
                }
                if (string2 != null) continue;
                string2 = __dftMimeMap.get(string3);
            }
        }
        if (string2 == null) {
            if (this._mimeMap != null) {
                string2 = this._mimeMap.get("*");
            }
            if (string2 == null) {
                string2 = __dftMimeMap.get("*");
            }
        }
        return string2;
    }

    public void addMimeMapping(String string, String string2) {
        this._mimeMap.put(StringUtil.asciiToLowerCase(string), MimeTypes.normalizeMimeType(string2));
    }

    public static Set<String> getKnownMimeTypes() {
        return new HashSet<String>(__dftMimeMap.values());
    }

    private static String normalizeMimeType(String string) {
        Type type = CACHE.get(string);
        if (type != null) {
            return type.asString();
        }
        return StringUtil.asciiToLowerCase(string);
    }

    public static String getCharsetFromContentType(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        block13: for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (bl && n3 != 10) {
                if ('\"' != c) continue;
                bl = false;
                continue;
            }
            if (';' == c && n3 <= 8) {
                n3 = 1;
                continue;
            }
            switch (n3) {
                case 0: {
                    if ('\"' != c) continue block13;
                    bl = true;
                    continue block13;
                }
                case 1: {
                    if ('c' == c) {
                        n3 = 2;
                        continue block13;
                    }
                    if (' ' == c) continue block13;
                    n3 = 0;
                    continue block13;
                }
                case 2: {
                    if ('h' == c) {
                        n3 = 3;
                        continue block13;
                    }
                    n3 = 0;
                    continue block13;
                }
                case 3: {
                    if ('a' == c) {
                        n3 = 4;
                        continue block13;
                    }
                    n3 = 0;
                    continue block13;
                }
                case 4: {
                    if ('r' == c) {
                        n3 = 5;
                        continue block13;
                    }
                    n3 = 0;
                    continue block13;
                }
                case 5: {
                    if ('s' == c) {
                        n3 = 6;
                        continue block13;
                    }
                    n3 = 0;
                    continue block13;
                }
                case 6: {
                    if ('e' == c) {
                        n3 = 7;
                        continue block13;
                    }
                    n3 = 0;
                    continue block13;
                }
                case 7: {
                    if ('t' == c) {
                        n3 = 8;
                        continue block13;
                    }
                    n3 = 0;
                    continue block13;
                }
                case 8: {
                    if ('=' == c) {
                        n3 = 9;
                        continue block13;
                    }
                    if (' ' == c) continue block13;
                    n3 = 0;
                    continue block13;
                }
                case 9: {
                    if (' ' == c) continue block13;
                    if ('\"' == c) {
                        bl = true;
                        n4 = n + 1;
                        n3 = 10;
                        continue block13;
                    }
                    n4 = n;
                    n3 = 10;
                    continue block13;
                }
                case 10: {
                    if ((bl || ';' != c && ' ' != c) && (!bl || '\"' != c)) continue block13;
                    return StringUtil.normalizeCharset(string, n4, n - n4);
                }
            }
        }
        if (n3 == 10) {
            return StringUtil.normalizeCharset(string, n4, n - n4);
        }
        return null;
    }

    public static Map<String, String> getInferredEncodings() {
        return __inferredEncodings;
    }

    public static Map<String, String> getAssumedEncodings() {
        return __assumedEncodings;
    }

    @Deprecated
    public static String inferCharsetFromContentType(String string) {
        return MimeTypes.getCharsetAssumedFromContentType(string);
    }

    public static String getCharsetInferredFromContentType(String string) {
        return __inferredEncodings.get(string);
    }

    public static String getCharsetAssumedFromContentType(String string) {
        return __assumedEncodings.get(string);
    }

    public static String getContentTypeWithoutCharset(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        StringBuilder stringBuilder = null;
        block19: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ('\"' == c) {
                bl = !bl;
                switch (n2) {
                    case 11: {
                        stringBuilder.append(c);
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 9: {
                        stringBuilder = new StringBuilder();
                        stringBuilder.append(string, 0, n3 + 1);
                        n2 = 10;
                        break;
                    }
                    default: {
                        n3 = i;
                        n2 = 0;
                        break;
                    }
                }
                continue;
            }
            if (bl) {
                if (stringBuilder == null || n2 == 10) continue;
                stringBuilder.append(c);
                continue;
            }
            switch (n2) {
                case 0: {
                    if (';' == c) {
                        n2 = 1;
                        continue block19;
                    }
                    if (' ' == c) continue block19;
                    n3 = i;
                    continue block19;
                }
                case 1: {
                    if ('c' == c) {
                        n2 = 2;
                        continue block19;
                    }
                    if (' ' == c) continue block19;
                    n2 = 0;
                    continue block19;
                }
                case 2: {
                    if ('h' == c) {
                        n2 = 3;
                        continue block19;
                    }
                    n2 = 0;
                    continue block19;
                }
                case 3: {
                    if ('a' == c) {
                        n2 = 4;
                        continue block19;
                    }
                    n2 = 0;
                    continue block19;
                }
                case 4: {
                    if ('r' == c) {
                        n2 = 5;
                        continue block19;
                    }
                    n2 = 0;
                    continue block19;
                }
                case 5: {
                    if ('s' == c) {
                        n2 = 6;
                        continue block19;
                    }
                    n2 = 0;
                    continue block19;
                }
                case 6: {
                    if ('e' == c) {
                        n2 = 7;
                        continue block19;
                    }
                    n2 = 0;
                    continue block19;
                }
                case 7: {
                    if ('t' == c) {
                        n2 = 8;
                        continue block19;
                    }
                    n2 = 0;
                    continue block19;
                }
                case 8: {
                    if ('=' == c) {
                        n2 = 9;
                        continue block19;
                    }
                    if (' ' == c) continue block19;
                    n2 = 0;
                    continue block19;
                }
                case 9: {
                    if (' ' == c) continue block19;
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(string, 0, n3 + 1);
                    n2 = 10;
                    continue block19;
                }
                case 10: {
                    if (';' != c) continue block19;
                    stringBuilder.append(c);
                    n2 = 11;
                    continue block19;
                }
                case 11: {
                    if (' ' == c) continue block19;
                    stringBuilder.append(c);
                }
            }
        }
        if (stringBuilder == null) {
            return string;
        }
        return stringBuilder.toString();
    }

    static {
        block41: {
            InputStream iOException;
            block40: {
                LOG = Log.getLogger(MimeTypes.class);
                TYPES = new ArrayTrie<ByteBuffer>(512);
                __dftMimeMap = new HashMap<String, String>();
                __inferredEncodings = new HashMap<String, String>();
                __assumedEncodings = new HashMap<String, String>();
                CACHE = new ArrayTrie<Type>(512);
                for (Type type : Type.values()) {
                    CACHE.put(type.toString(), type);
                    TYPES.put(type.toString(), type.asBuffer());
                    int n = type.toString().indexOf(";charset=");
                    if (n > 0) {
                        String string2 = StringUtil.replace(type.toString(), ";charset=", "; charset=");
                        CACHE.put(string2, type);
                        TYPES.put(string2, type.asBuffer());
                    }
                    if (!type.isCharsetAssumed()) continue;
                    __assumedEncodings.put(type.asString(), type.getCharsetString());
                }
                String string3 = "org/eclipse/jetty/http/mime.properties";
                try {
                    iOException = MimeTypes.class.getClassLoader().getResourceAsStream(string3);
                    try {
                        if (iOException == null) {
                            LOG.warn("Missing mime-type resource: {}", string3);
                            break block40;
                        }
                        try (InputStreamReader inputStreamReader = new InputStreamReader(iOException, StandardCharsets.UTF_8);){
                            Properties properties = new Properties();
                            properties.load(inputStreamReader);
                            properties.stringPropertyNames().stream().filter(string -> string != null).forEach(string -> __dftMimeMap.put(StringUtil.asciiToLowerCase(string), MimeTypes.normalizeMimeType(properties.getProperty((String)string))));
                            if (__dftMimeMap.isEmpty()) {
                                LOG.warn("Empty mime types at {}", string3);
                            } else if (__dftMimeMap.size() < properties.keySet().size()) {
                                LOG.warn("Duplicate or null mime-type extension in resource: {}", string3);
                            }
                        }
                        catch (IOException inputStreamReader2) {
                            LOG.warn(inputStreamReader2.toString(), new Object[0]);
                            LOG.debug(inputStreamReader2);
                        }
                    }
                    finally {
                        if (iOException != null) {
                            iOException.close();
                        }
                    }
                }
                catch (IOException iOException2) {
                    LOG.warn(iOException2.toString(), new Object[0]);
                    LOG.debug(iOException2);
                }
            }
            String string4 = "org/eclipse/jetty/http/encoding.properties";
            try {
                iOException = MimeTypes.class.getClassLoader().getResourceAsStream(string4);
                try {
                    if (iOException == null) {
                        LOG.warn("Missing encoding resource: {}", string4);
                        break block41;
                    }
                    try (InputStreamReader inputStreamReader = new InputStreamReader(iOException, StandardCharsets.UTF_8);){
                        Properties properties = new Properties();
                        properties.load(inputStreamReader);
                        properties.stringPropertyNames().stream().filter(string -> string != null).forEach(string -> {
                            String string2 = properties.getProperty((String)string);
                            if (string2.startsWith("-")) {
                                __assumedEncodings.put((String)string, string2.substring(1));
                            } else {
                                __inferredEncodings.put((String)string, properties.getProperty((String)string));
                            }
                        });
                        if (__inferredEncodings.isEmpty()) {
                            LOG.warn("Empty encodings at {}", string4);
                        } else if (__inferredEncodings.size() + __assumedEncodings.size() < properties.keySet().size()) {
                            LOG.warn("Null or duplicate encodings in resource: {}", string4);
                        }
                    }
                    catch (IOException iOException3) {
                        LOG.warn(iOException3.toString(), new Object[0]);
                        LOG.debug(iOException3);
                    }
                }
                finally {
                    if (iOException != null) {
                        iOException.close();
                    }
                }
            }
            catch (IOException iOException4) {
                LOG.warn(iOException4.toString(), new Object[0]);
                LOG.debug(iOException4);
            }
        }
    }

    public static enum Type {
        FORM_ENCODED("application/x-www-form-urlencoded"),
        MESSAGE_HTTP("message/http"),
        MULTIPART_BYTERANGES("multipart/byteranges"),
        MULTIPART_FORM_DATA("multipart/form-data"),
        TEXT_HTML("text/html"),
        TEXT_PLAIN("text/plain"),
        TEXT_XML("text/xml"),
        TEXT_JSON("text/json", StandardCharsets.UTF_8),
        APPLICATION_JSON("application/json", StandardCharsets.UTF_8),
        TEXT_HTML_8859_1("text/html;charset=iso-8859-1", TEXT_HTML),
        TEXT_HTML_UTF_8("text/html;charset=utf-8", TEXT_HTML),
        TEXT_PLAIN_8859_1("text/plain;charset=iso-8859-1", TEXT_PLAIN),
        TEXT_PLAIN_UTF_8("text/plain;charset=utf-8", TEXT_PLAIN),
        TEXT_XML_8859_1("text/xml;charset=iso-8859-1", TEXT_XML),
        TEXT_XML_UTF_8("text/xml;charset=utf-8", TEXT_XML),
        TEXT_JSON_8859_1("text/json;charset=iso-8859-1", TEXT_JSON),
        TEXT_JSON_UTF_8("text/json;charset=utf-8", TEXT_JSON),
        APPLICATION_JSON_8859_1("application/json;charset=iso-8859-1", APPLICATION_JSON),
        APPLICATION_JSON_UTF_8("application/json;charset=utf-8", APPLICATION_JSON);

        private final String _string;
        private final Type _base;
        private final ByteBuffer _buffer;
        private final Charset _charset;
        private final String _charsetString;
        private final boolean _assumedCharset;
        private final HttpField _field;

        private Type(String string2) {
            this._string = string2;
            this._buffer = BufferUtil.toBuffer(string2);
            this._base = this;
            this._charset = null;
            this._charsetString = null;
            this._assumedCharset = false;
            this._field = new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, this._string);
        }

        private Type(String string2, Type type) {
            this._string = string2;
            this._buffer = BufferUtil.toBuffer(string2);
            this._base = type;
            int n2 = string2.indexOf(";charset=");
            this._charset = Charset.forName(string2.substring(n2 + 9));
            this._charsetString = this._charset.toString().toLowerCase(Locale.ENGLISH);
            this._assumedCharset = false;
            this._field = new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, this._string);
        }

        private Type(String string2, Charset charset) {
            this._string = string2;
            this._base = this;
            this._buffer = BufferUtil.toBuffer(string2);
            this._charset = charset;
            this._charsetString = this._charset == null ? null : this._charset.toString().toLowerCase(Locale.ENGLISH);
            this._assumedCharset = true;
            this._field = new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, this._string);
        }

        public ByteBuffer asBuffer() {
            return this._buffer.asReadOnlyBuffer();
        }

        public Charset getCharset() {
            return this._charset;
        }

        public String getCharsetString() {
            return this._charsetString;
        }

        public boolean is(String string) {
            return this._string.equalsIgnoreCase(string);
        }

        public String asString() {
            return this._string;
        }

        public String toString() {
            return this._string;
        }

        public boolean isCharsetAssumed() {
            return this._assumedCharset;
        }

        public HttpField getContentTypeField() {
            return this._field;
        }

        public Type getBaseType() {
            return this._base;
        }
    }
}

