/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpGenerator {
    private static final Logger LOG = Log.getLogger(HttpGenerator.class);
    public static final boolean __STRICT = Boolean.getBoolean("org.eclipse.jetty.http.HttpGenerator.STRICT");
    private static final byte[] __colon_space = new byte[]{58, 32};
    public static final MetaData.Response CONTINUE_100_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 100, null, null, -1L);
    public static final MetaData.Response PROGRESS_102_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 102, null, null, -1L);
    public static final MetaData.Response RESPONSE_500_INFO = new MetaData.Response(HttpVersion.HTTP_1_1, 500, null, new HttpFields(){
        {
            this.put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
        }
    }, 0L);
    public static final int CHUNK_SIZE = 12;
    private State _state = State.START;
    private HttpTokens.EndOfContent _endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
    private long _contentPrepared = 0L;
    private boolean _noContentResponse = false;
    private Boolean _persistent = null;
    private Supplier<HttpFields> _trailers = null;
    private final int _send;
    private static final int SEND_SERVER = 1;
    private static final int SEND_XPOWEREDBY = 2;
    private static final Trie<Boolean> ASSUMED_CONTENT_METHODS = new ArrayTrie<Boolean>(8);
    private boolean _needCRLF = false;
    private static final byte[] ZERO_CHUNK;
    private static final byte[] LAST_CHUNK;
    private static final byte[] CONTENT_LENGTH_0;
    private static final byte[] CONNECTION_CLOSE;
    private static final byte[] HTTP_1_1_SPACE;
    private static final byte[] TRANSFER_ENCODING_CHUNKED;
    private static final byte[][] SEND;
    private static final PreparedResponse[] __preprepared;

    public static void setJettyVersion(String string) {
        HttpGenerator.SEND[1] = StringUtil.getBytes("Server: " + string + "\r\n");
        HttpGenerator.SEND[2] = StringUtil.getBytes("X-Powered-By: " + string + "\r\n");
        HttpGenerator.SEND[3] = StringUtil.getBytes("Server: " + string + "\r\nX-Powered-By: " + string + "\r\n");
    }

    public HttpGenerator() {
        this(false, false);
    }

    public HttpGenerator(boolean bl, boolean bl2) {
        this._send = (bl ? 1 : 0) | (bl2 ? 2 : 0);
    }

    public void reset() {
        this._state = State.START;
        this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
        this._noContentResponse = false;
        this._persistent = null;
        this._contentPrepared = 0L;
        this._needCRLF = false;
        this._trailers = null;
    }

    @Deprecated
    public boolean getSendServerVersion() {
        return (this._send & 1) != 0;
    }

    @Deprecated
    public void setSendServerVersion(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public State getState() {
        return this._state;
    }

    public boolean isState(State state) {
        return this._state == state;
    }

    public boolean isIdle() {
        return this._state == State.START;
    }

    public boolean isEnd() {
        return this._state == State.END;
    }

    public boolean isCommitted() {
        return this._state.ordinal() >= State.COMMITTED.ordinal();
    }

    public boolean isChunking() {
        return this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT;
    }

    public boolean isNoContent() {
        return this._noContentResponse;
    }

    public void setPersistent(boolean bl) {
        this._persistent = bl;
    }

    public boolean isPersistent() {
        return Boolean.TRUE.equals(this._persistent);
    }

    public boolean isWritten() {
        return this._contentPrepared > 0L;
    }

    public long getContentPrepared() {
        return this._contentPrepared;
    }

    public void abort() {
        this._persistent = false;
        this._state = State.END;
        this._endOfContent = null;
    }

    public Result generateRequest(MetaData.Request request, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, boolean bl) throws IOException {
        switch (this._state) {
            case START: {
                if (request == null) {
                    return Result.NEED_INFO;
                }
                if (byteBuffer == null) {
                    return Result.NEED_HEADER;
                }
                int n = BufferUtil.flipToFill(byteBuffer);
                try {
                    this.generateRequestLine(request, byteBuffer);
                    if (request.getHttpVersion() == HttpVersion.HTTP_0_9) {
                        throw new BadMessageException(500, "HTTP/0.9 not supported");
                    }
                    this.generateHeaders(request, byteBuffer, byteBuffer3, bl);
                    boolean bl2 = request.getFields().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
                    if (bl2) {
                        this._state = State.COMMITTED;
                    } else {
                        int n2 = BufferUtil.length(byteBuffer3);
                        if (n2 > 0) {
                            this._contentPrepared += (long)n2;
                            if (this.isChunking()) {
                                this.prepareChunk(byteBuffer, n2);
                            }
                        }
                        this._state = bl ? State.COMPLETING : State.COMMITTED;
                    }
                    Result result = Result.FLUSH;
                    return result;
                }
                catch (BadMessageException badMessageException) {
                    throw badMessageException;
                }
                catch (BufferOverflowException bufferOverflowException) {
                    LOG.ignore(bufferOverflowException);
                    Result result = Result.HEADER_OVERFLOW;
                    return result;
                }
                catch (Exception exception) {
                    throw new BadMessageException(500, exception.getMessage(), exception);
                }
                finally {
                    BufferUtil.flipToFlush(byteBuffer, n);
                }
            }
            case COMMITTED: {
                return this.committed(byteBuffer2, byteBuffer3, bl);
            }
            case COMPLETING: {
                return this.completing(byteBuffer2, byteBuffer3);
            }
            case END: {
                if (BufferUtil.hasContent(byteBuffer3)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("discarding content in COMPLETING", new Object[0]);
                    }
                    BufferUtil.clear(byteBuffer3);
                }
                return Result.DONE;
            }
        }
        throw new IllegalStateException();
    }

    private Result committed(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) {
        int n = BufferUtil.length(byteBuffer2);
        if (n > 0) {
            if (this.isChunking()) {
                if (byteBuffer == null) {
                    return Result.NEED_CHUNK;
                }
                BufferUtil.clearToFill(byteBuffer);
                this.prepareChunk(byteBuffer, n);
                BufferUtil.flipToFlush(byteBuffer, 0);
            }
            this._contentPrepared += (long)n;
        }
        if (bl) {
            this._state = State.COMPLETING;
            return n > 0 ? Result.FLUSH : Result.CONTINUE;
        }
        return n > 0 ? Result.FLUSH : Result.DONE;
    }

    private Result completing(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (BufferUtil.hasContent(byteBuffer2)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("discarding content in COMPLETING", new Object[0]);
            }
            BufferUtil.clear(byteBuffer2);
        }
        if (this.isChunking()) {
            if (this._trailers != null) {
                if (byteBuffer == null || byteBuffer.capacity() <= 12) {
                    return Result.NEED_CHUNK_TRAILER;
                }
                HttpFields httpFields = this._trailers.get();
                if (httpFields != null) {
                    BufferUtil.clearToFill(byteBuffer);
                    this.generateTrailers(byteBuffer, httpFields);
                    BufferUtil.flipToFlush(byteBuffer, 0);
                    this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
                    return Result.FLUSH;
                }
            }
            if (byteBuffer == null) {
                return Result.NEED_CHUNK;
            }
            BufferUtil.clearToFill(byteBuffer);
            this.prepareChunk(byteBuffer, 0);
            BufferUtil.flipToFlush(byteBuffer, 0);
            this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
            return Result.FLUSH;
        }
        this._state = State.END;
        return Boolean.TRUE.equals(this._persistent) ? Result.DONE : Result.SHUTDOWN_OUT;
    }

    @Deprecated
    public Result generateResponse(MetaData.Response response, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, boolean bl) throws IOException {
        return this.generateResponse(response, false, byteBuffer, byteBuffer2, byteBuffer3, bl);
    }

    public Result generateResponse(MetaData.Response response, boolean bl, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, boolean bl2) throws IOException {
        switch (this._state) {
            case START: {
                if (response == null) {
                    return Result.NEED_INFO;
                }
                HttpVersion httpVersion = response.getHttpVersion();
                if (httpVersion == null) {
                    throw new BadMessageException(500, "No version");
                }
                if (httpVersion == HttpVersion.HTTP_0_9) {
                    this._persistent = false;
                    this._endOfContent = HttpTokens.EndOfContent.EOF_CONTENT;
                    if (BufferUtil.hasContent(byteBuffer3)) {
                        this._contentPrepared += (long)byteBuffer3.remaining();
                    }
                    this._state = bl2 ? State.COMPLETING : State.COMMITTED;
                    return Result.FLUSH;
                }
                if (byteBuffer == null) {
                    return Result.NEED_HEADER;
                }
                int n = BufferUtil.flipToFill(byteBuffer);
                try {
                    this.generateResponseLine(response, byteBuffer);
                    int n2 = response.getStatus();
                    if (n2 >= 100 && n2 < 200) {
                        this._noContentResponse = true;
                        if (n2 != 101) {
                            byteBuffer.put(HttpTokens.CRLF);
                            this._state = State.COMPLETING_1XX;
                            Result result = Result.FLUSH;
                            return result;
                        }
                    } else if (n2 == 204 || n2 == 304) {
                        this._noContentResponse = true;
                    }
                    this.generateHeaders(response, byteBuffer, byteBuffer3, bl2);
                    int n3 = BufferUtil.length(byteBuffer3);
                    if (n3 > 0) {
                        this._contentPrepared += (long)n3;
                        if (this.isChunking() && !bl) {
                            this.prepareChunk(byteBuffer, n3);
                        }
                    }
                    this._state = bl2 ? State.COMPLETING : State.COMMITTED;
                }
                catch (BadMessageException badMessageException) {
                    throw badMessageException;
                }
                catch (BufferOverflowException bufferOverflowException) {
                    LOG.ignore(bufferOverflowException);
                    Result result = Result.HEADER_OVERFLOW;
                    return result;
                }
                catch (Exception exception) {
                    throw new BadMessageException(500, exception.getMessage(), exception);
                }
                finally {
                    BufferUtil.flipToFlush(byteBuffer, n);
                }
                return Result.FLUSH;
            }
            case COMMITTED: {
                return this.committed(byteBuffer2, byteBuffer3, bl2);
            }
            case COMPLETING_1XX: {
                this.reset();
                return Result.DONE;
            }
            case COMPLETING: {
                return this.completing(byteBuffer2, byteBuffer3);
            }
            case END: {
                if (BufferUtil.hasContent(byteBuffer3)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("discarding content in COMPLETING", new Object[0]);
                    }
                    BufferUtil.clear(byteBuffer3);
                }
                return Result.DONE;
            }
        }
        throw new IllegalStateException();
    }

    private void prepareChunk(ByteBuffer byteBuffer, int n) {
        if (this._needCRLF) {
            BufferUtil.putCRLF(byteBuffer);
        }
        if (n > 0) {
            BufferUtil.putHexInt(byteBuffer, n);
            BufferUtil.putCRLF(byteBuffer);
            this._needCRLF = true;
        } else {
            byteBuffer.put(LAST_CHUNK);
            this._needCRLF = false;
        }
    }

    private void generateTrailers(ByteBuffer byteBuffer, HttpFields httpFields) {
        if (this._needCRLF) {
            BufferUtil.putCRLF(byteBuffer);
        }
        byteBuffer.put(ZERO_CHUNK);
        int n = httpFields.size();
        for (int i = 0; i < n; ++i) {
            HttpField httpField = httpFields.getField(i);
            HttpGenerator.putTo(httpField, byteBuffer);
        }
        BufferUtil.putCRLF(byteBuffer);
    }

    private void generateRequestLine(MetaData.Request request, ByteBuffer byteBuffer) {
        byteBuffer.put(StringUtil.getBytes(request.getMethod()));
        byteBuffer.put((byte)32);
        byteBuffer.put(StringUtil.getBytes(request.getURIString()));
        byteBuffer.put((byte)32);
        byteBuffer.put(request.getHttpVersion().toBytes());
        byteBuffer.put(HttpTokens.CRLF);
    }

    private void generateResponseLine(MetaData.Response response, ByteBuffer byteBuffer) {
        int n = response.getStatus();
        PreparedResponse preparedResponse = n < __preprepared.length ? __preprepared[n] : null;
        String string = response.getReason();
        if (preparedResponse != null) {
            if (string == null) {
                byteBuffer.put(preparedResponse._responseLine);
            } else {
                byteBuffer.put(preparedResponse._schemeCode);
                byteBuffer.put(this.getReasonBytes(string));
                byteBuffer.put(HttpTokens.CRLF);
            }
        } else {
            byteBuffer.put(HTTP_1_1_SPACE);
            byteBuffer.put((byte)(48 + n / 100));
            byteBuffer.put((byte)(48 + n % 100 / 10));
            byteBuffer.put((byte)(48 + n % 10));
            byteBuffer.put((byte)32);
            if (string == null) {
                byteBuffer.put((byte)(48 + n / 100));
                byteBuffer.put((byte)(48 + n % 100 / 10));
                byteBuffer.put((byte)(48 + n % 10));
            } else {
                byteBuffer.put(this.getReasonBytes(string));
            }
            byteBuffer.put(HttpTokens.CRLF);
        }
    }

    private byte[] getReasonBytes(String string) {
        if (string.length() > 1024) {
            string = string.substring(0, 1024);
        }
        byte[] byArray = StringUtil.getBytes(string);
        int n = byArray.length;
        while (n-- > 0) {
            if (byArray[n] != 13 && byArray[n] != 10) continue;
            byArray[n] = 63;
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateHeaders(MetaData metaData, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) {
        int n;
        boolean bl2;
        int n2;
        int n3;
        int n4;
        MetaData.Response response;
        MetaData.Request request = metaData instanceof MetaData.Request ? (MetaData.Request)metaData : null;
        MetaData.Response response2 = response = metaData instanceof MetaData.Response ? (MetaData.Response)metaData : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("generateHeaders {} last={} content={}", metaData, bl, BufferUtil.toDetailString(byteBuffer2));
            LOG.debug(metaData.getFields().toString(), new Object[0]);
        }
        int n5 = this._send;
        HttpField httpField = null;
        boolean bl3 = metaData.getHttpVersion() == HttpVersion.HTTP_1_1;
        boolean bl4 = false;
        this._trailers = bl3 ? metaData.getTrailerSupplier() : null;
        boolean bl5 = this._trailers != null;
        boolean bl6 = false;
        long l = metaData.getContentLength();
        boolean bl7 = false;
        HttpFields httpFields = metaData.getFields();
        if (httpFields != null) {
            n4 = httpFields.size();
            block7: for (n3 = 0; n3 < n4; ++n3) {
                HttpField httpField2 = httpFields.getField(n3);
                HttpHeader httpHeader = httpField2.getHeader();
                if (httpHeader == null) {
                    HttpGenerator.putTo(httpField2, byteBuffer);
                    continue;
                }
                switch (httpHeader) {
                    case CONTENT_LENGTH: {
                        if (l < 0L) {
                            l = httpField2.getLongValue();
                        } else if (l != httpField2.getLongValue()) {
                            throw new BadMessageException(500, String.format("Incorrect Content-Length %d!=%d", l, httpField2.getLongValue()));
                        }
                        bl7 = true;
                        continue block7;
                    }
                    case CONTENT_TYPE: {
                        bl6 = true;
                        HttpGenerator.putTo(httpField2, byteBuffer);
                        continue block7;
                    }
                    case TRANSFER_ENCODING: {
                        if (!bl3) continue block7;
                        httpField = httpField2;
                        bl5 = httpField2.contains(HttpHeaderValue.CHUNKED.asString());
                        continue block7;
                    }
                    case CONNECTION: {
                        n2 = httpField2.contains(HttpHeaderValue.KEEP_ALIVE.asString());
                        if (n2 != 0 && metaData.getHttpVersion() == HttpVersion.HTTP_1_0 && this._persistent == null) {
                            this._persistent = true;
                        }
                        if (httpField2.contains(HttpHeaderValue.CLOSE.asString())) {
                            bl4 = true;
                            this._persistent = false;
                        }
                        if (n2 != 0 && Boolean.FALSE.equals(this._persistent)) {
                            httpField2 = new HttpField(HttpHeader.CONNECTION, Stream.of(httpField2.getValues()).filter(string -> !HttpHeaderValue.KEEP_ALIVE.is((String)string)).collect(Collectors.joining(", ")));
                        }
                        HttpGenerator.putTo(httpField2, byteBuffer);
                        continue block7;
                    }
                    case SERVER: {
                        n5 &= 0xFFFFFFFE;
                        HttpGenerator.putTo(httpField2, byteBuffer);
                        continue block7;
                    }
                    default: {
                        HttpGenerator.putTo(httpField2, byteBuffer);
                    }
                }
            }
        }
        if (bl && l < 0L && this._trailers == null) {
            l = this._contentPrepared + (long)BufferUtil.length(byteBuffer2);
        }
        n4 = request != null && Boolean.TRUE.equals(ASSUMED_CONTENT_METHODS.get(request.getMethod())) ? 1 : 0;
        n3 = n4 != 0 || bl6 || bl5 ? 1 : 0;
        boolean bl8 = bl2 = request != null && l <= 0L && n3 == 0;
        if (this._persistent == null) {
            this._persistent = bl3 || request != null && HttpMethod.CONNECT.is(request.getMethod());
        }
        if (this._noContentResponse || bl2) {
            this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
            if (this._contentPrepared > 0L) {
                throw new BadMessageException(500, "Content for no content response");
            }
            if (bl7) {
                if (response != null && response.getStatus() == 304) {
                    HttpGenerator.putContentLength(byteBuffer, l);
                } else if (l > 0L) {
                    if (this._contentPrepared != 0L || !bl) throw new BadMessageException(500, "Content for no content response");
                    byteBuffer2.clear();
                }
            }
        } else if (bl3 && (bl5 || l < 0L && (this._persistent.booleanValue() || n4 != 0))) {
            this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
            if (httpField == null) {
                byteBuffer.put(TRANSFER_ENCODING_CHUNKED);
            } else if (httpField.toString().endsWith(HttpHeaderValue.CHUNKED.toString())) {
                HttpGenerator.putTo(httpField, byteBuffer);
                httpField = null;
            } else {
                if (bl5) throw new BadMessageException(500, "Bad Transfer-Encoding");
                HttpGenerator.putTo(new HttpField(HttpHeader.TRANSFER_ENCODING, httpField.getValue() + ",chunked"), byteBuffer);
                httpField = null;
            }
        } else if (l >= 0L && (request != null || this._persistent.booleanValue())) {
            this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
            HttpGenerator.putContentLength(byteBuffer, l);
        } else {
            if (response == null) throw new BadMessageException(500, "Unknown content length for request");
            this._endOfContent = HttpTokens.EndOfContent.EOF_CONTENT;
            this._persistent = false;
            if (l >= 0L && (l > 0L || n3 != 0 || bl7)) {
                HttpGenerator.putContentLength(byteBuffer, l);
            }
            if (bl3 && !bl4) {
                byteBuffer.put(CONNECTION_CLOSE);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this._endOfContent.toString(), new Object[0]);
        }
        if (httpField != null) {
            if (bl5) {
                String string2 = httpField.getValue();
                n2 = string2.lastIndexOf(44);
                if (n2 > 0 && string2.lastIndexOf(HttpHeaderValue.CHUNKED.toString(), n2) > n2) {
                    HttpGenerator.putTo(new HttpField(HttpHeader.TRANSFER_ENCODING, string2.substring(0, n2).trim()), byteBuffer);
                }
            } else {
                HttpGenerator.putTo(httpField, byteBuffer);
            }
        }
        int n6 = n = response != null ? response.getStatus() : -1;
        if (n > 199) {
            byteBuffer.put(SEND[n5]);
        }
        byteBuffer.put(HttpTokens.CRLF);
    }

    private static void putContentLength(ByteBuffer byteBuffer, long l) {
        if (l == 0L) {
            byteBuffer.put(CONTENT_LENGTH_0);
        } else {
            byteBuffer.put(HttpHeader.CONTENT_LENGTH.getBytesColonSpace());
            BufferUtil.putDecLong(byteBuffer, l);
            byteBuffer.put(HttpTokens.CRLF);
        }
    }

    public static byte[] getReasonBuffer(int n) {
        PreparedResponse preparedResponse;
        PreparedResponse preparedResponse2 = preparedResponse = n < __preprepared.length ? __preprepared[n] : null;
        if (preparedResponse != null) {
            return preparedResponse._reason;
        }
        return null;
    }

    public String toString() {
        return String.format("%s@%x{s=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state});
    }

    private static void putSanitisedName(String string, ByteBuffer byteBuffer) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0000' || c > '\u00ff' || c == '\r' || c == '\n' || c == ':') {
                byteBuffer.put((byte)63);
                continue;
            }
            byteBuffer.put((byte)(0xFF & c));
        }
    }

    private static void putSanitisedValue(String string, ByteBuffer byteBuffer) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0000' || c > '\u00ff' || c == '\r' || c == '\n') {
                byteBuffer.put((byte)32);
                continue;
            }
            byteBuffer.put((byte)(0xFF & c));
        }
    }

    public static void putTo(HttpField httpField, ByteBuffer byteBuffer) {
        if (httpField instanceof PreEncodedHttpField) {
            ((PreEncodedHttpField)httpField).putTo(byteBuffer, HttpVersion.HTTP_1_0);
        } else {
            HttpHeader httpHeader = httpField.getHeader();
            if (httpHeader != null) {
                byteBuffer.put(httpHeader.getBytesColonSpace());
                HttpGenerator.putSanitisedValue(httpField.getValue(), byteBuffer);
            } else {
                HttpGenerator.putSanitisedName(httpField.getName(), byteBuffer);
                byteBuffer.put(__colon_space);
                HttpGenerator.putSanitisedValue(httpField.getValue(), byteBuffer);
            }
            BufferUtil.putCRLF(byteBuffer);
        }
    }

    public static void putTo(HttpFields httpFields, ByteBuffer byteBuffer) {
        for (HttpField httpField : httpFields) {
            if (httpField == null) continue;
            HttpGenerator.putTo(httpField, byteBuffer);
        }
        BufferUtil.putCRLF(byteBuffer);
    }

    static {
        ASSUMED_CONTENT_METHODS.put(HttpMethod.POST.asString(), Boolean.TRUE);
        ASSUMED_CONTENT_METHODS.put(HttpMethod.PUT.asString(), Boolean.TRUE);
        ZERO_CHUNK = new byte[]{48, 13, 10};
        LAST_CHUNK = new byte[]{48, 13, 10, 13, 10};
        CONTENT_LENGTH_0 = StringUtil.getBytes("Content-Length: 0\r\n");
        CONNECTION_CLOSE = StringUtil.getBytes("Connection: close\r\n");
        HTTP_1_1_SPACE = StringUtil.getBytes((Object)((Object)HttpVersion.HTTP_1_1) + " ");
        TRANSFER_ENCODING_CHUNKED = StringUtil.getBytes("Transfer-Encoding: chunked\r\n");
        SEND = new byte[][]{new byte[0], StringUtil.getBytes("Server: Jetty(9.x.x)\r\n"), StringUtil.getBytes("X-Powered-By: Jetty(9.x.x)\r\n"), StringUtil.getBytes("Server: Jetty(9.x.x)\r\nX-Powered-By: Jetty(9.x.x)\r\n")};
        __preprepared = new PreparedResponse[512];
        int n = HttpVersion.HTTP_1_1.toString().length();
        for (int i = 0; i < __preprepared.length; ++i) {
            HttpStatus.Code code = HttpStatus.getCode(i);
            if (code == null) continue;
            String string = code.getMessage();
            byte[] byArray = new byte[n + 5 + string.length() + 2];
            HttpVersion.HTTP_1_1.toBuffer().get(byArray, 0, n);
            byArray[n + 0] = 32;
            byArray[n + 1] = (byte)(48 + i / 100);
            byArray[n + 2] = (byte)(48 + i % 100 / 10);
            byArray[n + 3] = (byte)(48 + i % 10);
            byArray[n + 4] = 32;
            for (int j = 0; j < string.length(); ++j) {
                byArray[n + 5 + j] = (byte)string.charAt(j);
            }
            byArray[n + 5 + string.length()] = 13;
            byArray[n + 6 + string.length()] = 10;
            HttpGenerator.__preprepared[i] = new PreparedResponse();
            HttpGenerator.__preprepared[i]._schemeCode = Arrays.copyOfRange(byArray, 0, n + 5);
            HttpGenerator.__preprepared[i]._reason = Arrays.copyOfRange(byArray, n + 5, byArray.length - 2);
            HttpGenerator.__preprepared[i]._responseLine = byArray;
        }
    }

    private static class PreparedResponse {
        byte[] _reason;
        byte[] _schemeCode;
        byte[] _responseLine;

        private PreparedResponse() {
        }
    }

    public static enum Result {
        NEED_CHUNK,
        NEED_INFO,
        NEED_HEADER,
        HEADER_OVERFLOW,
        NEED_CHUNK_TRAILER,
        FLUSH,
        CONTINUE,
        SHUTDOWN_OUT,
        DONE;

    }

    public static enum State {
        START,
        COMMITTED,
        COMPLETING,
        COMPLETING_1XX,
        END;

    }
}

