/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.AbstractAuthentication;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SPNEGOAuthentication
extends AbstractAuthentication {
    private static final Logger LOG = Log.getLogger(SPNEGOAuthentication.class);
    private static final String NEGOTIATE = HttpHeader.NEGOTIATE.asString();
    private final GSSManager gssManager = GSSManager.getInstance();
    private String userName;
    private String userPassword;
    private Path userKeyTabPath;
    private String serviceName;
    private boolean useTicketCache;
    private Path ticketCachePath;
    private boolean renewTGT;

    public SPNEGOAuthentication(URI uRI) {
        super(uRI, "<<ANY_REALM>>");
    }

    @Override
    public String getType() {
        return NEGOTIATE;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String string) {
        this.userPassword = string;
    }

    public Path getUserKeyTabPath() {
        return this.userKeyTabPath;
    }

    public void setUserKeyTabPath(Path path) {
        this.userKeyTabPath = path;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public boolean isUseTicketCache() {
        return this.useTicketCache;
    }

    public void setUseTicketCache(boolean bl) {
        this.useTicketCache = bl;
    }

    public Path getTicketCachePath() {
        return this.ticketCachePath;
    }

    public void setTicketCachePath(Path path) {
        this.ticketCachePath = path;
    }

    public boolean isRenewTGT() {
        return this.renewTGT;
    }

    public void setRenewTGT(boolean bl) {
        this.renewTGT = bl;
    }

    @Override
    public Authentication.Result authenticate(Request request, ContentResponse contentResponse, Authentication.HeaderInfo headerInfo, Attributes attributes) {
        String string;
        SPNEGOContext sPNEGOContext = (SPNEGOContext)attributes.getAttribute(SPNEGOContext.ATTRIBUTE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Authenticate with context {}", sPNEGOContext);
        }
        if (sPNEGOContext == null) {
            sPNEGOContext = this.login();
            attributes.setAttribute(SPNEGOContext.ATTRIBUTE, sPNEGOContext);
        }
        byte[] byArray = (string = headerInfo.getBase64()) == null ? new byte[]{} : Base64.getDecoder().decode(string);
        byte[] byArray2 = Subject.doAs(sPNEGOContext.subject, this.initGSSContext(sPNEGOContext, request.getHost(), byArray));
        String string2 = byArray2 == null ? null : new String(Base64.getEncoder().encode(byArray2));
        return new SPNEGOResult(null, string2);
    }

    private SPNEGOContext login() {
        try {
            String string = this.getUserName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Logging in user {}", string);
            }
            PasswordCallbackHandler passwordCallbackHandler = new PasswordCallbackHandler();
            LoginContext loginContext = new LoginContext("", null, passwordCallbackHandler, new SPNEGOConfiguration());
            loginContext.login();
            Subject subject = loginContext.getSubject();
            SPNEGOContext sPNEGOContext = new SPNEGOContext();
            sPNEGOContext.subject = subject;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initialized {}", sPNEGOContext);
            }
            return sPNEGOContext;
        }
        catch (LoginException loginException) {
            throw new RuntimeException(loginException);
        }
    }

    private PrivilegedAction<byte[]> initGSSContext(SPNEGOContext sPNEGOContext, String string, byte[] byArray) {
        return () -> {
            try {
                Object object;
                GSSContext gSSContext = sPNEGOContext.gssContext;
                if (gSSContext == null) {
                    object = this.getServiceName() + "@" + string;
                    GSSName gSSName = this.gssManager.createName((String)object, GSSName.NT_HOSTBASED_SERVICE);
                    Oid oid = new Oid("1.3.6.1.5.5.2");
                    gSSContext = this.gssManager.createContext(gSSName, oid, null, Integer.MAX_VALUE);
                    sPNEGOContext.gssContext = gSSContext;
                    gSSContext.requestMutualAuth(true);
                }
                object = gSSContext.initSecContext(byArray, 0, byArray.length);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} {}", gSSContext.isEstablished() ? "Initialized" : "Initializing", gSSContext);
                }
                return object;
            }
            catch (GSSException gSSException) {
                throw new RuntimeException(gSSException);
            }
        };
    }

    private class SPNEGOConfiguration
    extends Configuration {
        private SPNEGOConfiguration() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
            Object object;
            boolean bl;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (LOG.isDebugEnabled()) {
                hashMap.put("debug", "true");
            }
            hashMap.put("refreshKrb5Config", "true");
            hashMap.put("principal", SPNEGOAuthentication.this.getUserName());
            hashMap.put("isInitiator", "true");
            Path path = SPNEGOAuthentication.this.getUserKeyTabPath();
            if (path != null) {
                hashMap.put("doNotPrompt", "true");
                hashMap.put("useKeyTab", "true");
                hashMap.put("keyTab", path.toAbsolutePath().toString());
                hashMap.put("storeKey", "true");
            }
            if (bl = SPNEGOAuthentication.this.isUseTicketCache()) {
                hashMap.put("useTicketCache", "true");
                object = SPNEGOAuthentication.this.getTicketCachePath();
                if (object != null) {
                    hashMap.put("ticketCache", object.toAbsolutePath().toString());
                }
                hashMap.put("renewTGT", String.valueOf(SPNEGOAuthentication.this.isRenewTGT()));
            }
            object = "com.sun.security.auth.module.Krb5LoginModule";
            AppConfigurationEntry appConfigurationEntry = new AppConfigurationEntry((String)object, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, hashMap);
            return new AppConfigurationEntry[]{appConfigurationEntry};
        }
    }

    private class PasswordCallbackHandler
    implements CallbackHandler {
        private PasswordCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbackArray) throws IOException {
            PasswordCallback passwordCallback2 = Arrays.stream(callbackArray).filter(PasswordCallback.class::isInstance).map(PasswordCallback.class::cast).findAny().filter(passwordCallback -> passwordCallback.getPrompt().contains(SPNEGOAuthentication.this.getUserName())).orElseThrow(IOException::new);
            passwordCallback2.setPassword(SPNEGOAuthentication.this.getUserPassword().toCharArray());
        }
    }

    private static class SPNEGOContext {
        private static final String ATTRIBUTE = SPNEGOContext.class.getName();
        private Subject subject;
        private GSSContext gssContext;

        private SPNEGOContext() {
        }

        public String toString() {
            return String.format("%s@%x[context=%s]", this.getClass().getSimpleName(), this.hashCode(), this.gssContext);
        }
    }

    public static class SPNEGOResult
    implements Authentication.Result {
        private final URI uri;
        private final HttpHeader header;
        private final String value;

        public SPNEGOResult(URI uRI, String string) {
            this(uRI, HttpHeader.AUTHORIZATION, string);
        }

        public SPNEGOResult(URI uRI, HttpHeader httpHeader, String string) {
            this.uri = uRI;
            this.header = httpHeader;
            this.value = NEGOTIATE + (string == null ? "" : " " + string);
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        @Override
        public void apply(Request request) {
            request.header(this.header, this.value);
        }
    }
}

