/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.DeferredContentProvider;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class InputStreamResponseListener
extends Response.Listener.Adapter {
    private static final Logger LOG = Log.getLogger(InputStreamResponseListener.class);
    private static final DeferredContentProvider.Chunk EOF = new DeferredContentProvider.Chunk(BufferUtil.EMPTY_BUFFER, Callback.NOOP);
    private final Object lock = this;
    private final CountDownLatch responseLatch = new CountDownLatch(1);
    private final CountDownLatch resultLatch = new CountDownLatch(1);
    private final AtomicReference<InputStream> stream = new AtomicReference();
    private final Queue<DeferredContentProvider.Chunk> chunks = new ArrayDeque<DeferredContentProvider.Chunk>();
    private Response response;
    private Result result;
    private Throwable failure;
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHeaders(Response response) {
        Object object = this.lock;
        synchronized (object) {
            this.response = response;
            this.responseLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onContent(Response response, ByteBuffer byteBuffer, Callback callback) {
        boolean bl;
        if (byteBuffer.remaining() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipped empty content {}", byteBuffer);
            }
            callback.succeeded();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            bl = this.closed;
            if (!bl) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Queueing content {}", byteBuffer);
                }
                this.chunks.add(new DeferredContentProvider.Chunk(byteBuffer, callback));
                this.lock.notifyAll();
            }
        }
        if (bl) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("InputStream closed, ignored content {}", byteBuffer);
            }
            callback.failed(new AsynchronousCloseException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(Response response) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.chunks.add(EOF);
            }
            this.lock.notifyAll();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("End of content", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Response response, Throwable throwable) {
        List<Callback> list;
        Object object = this.lock;
        synchronized (object) {
            if (this.failure != null) {
                return;
            }
            this.failure = throwable;
            list = this.drain();
            this.lock.notifyAll();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Content failure", throwable);
        }
        list.forEach(callback -> callback.failed(throwable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete(Result result) {
        Throwable throwable = result.getFailure();
        List<Object> list = Collections.emptyList();
        Object object = this.lock;
        synchronized (object) {
            this.result = result;
            if (result.isFailed() && this.failure == null) {
                this.failure = throwable;
                list = this.drain();
            }
            this.responseLatch.countDown();
            this.resultLatch.countDown();
            this.lock.notifyAll();
        }
        if (LOG.isDebugEnabled()) {
            if (throwable == null) {
                LOG.debug("Result success", new Object[0]);
            } else {
                LOG.debug("Result failure", throwable);
            }
        }
        list.forEach(callback -> callback.failed(throwable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response get(long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
        boolean bl;
        boolean bl2 = bl = !this.responseLatch.await(l, timeUnit);
        if (bl) {
            throw new TimeoutException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.response == null) {
                throw new ExecutionException(this.failure);
            }
            return this.response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result await(long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        boolean bl;
        boolean bl2 = bl = !this.resultLatch.await(l, timeUnit);
        if (bl) {
            throw new TimeoutException();
        }
        Object object = this.lock;
        synchronized (object) {
            return this.result;
        }
    }

    public InputStream getInputStream() {
        Input input = new Input();
        if (this.stream.compareAndSet(null, input)) {
            return input;
        }
        return IO.getClosedStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Callback> drain() {
        ArrayList<Callback> arrayList = new ArrayList<Callback>();
        Object object = this.lock;
        synchronized (object) {
            DeferredContentProvider.Chunk chunk;
            while ((chunk = this.chunks.peek()) != null && chunk != EOF) {
                arrayList.add(chunk.callback);
                this.chunks.poll();
            }
        }
        return arrayList;
    }

    private class Input
    extends InputStream {
        private Input() {
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray);
            if (n < 0) {
                return n;
            }
            return byArray[0] & 0xFF;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            try {
                int n3;
                Callback callback = null;
                Object object = InputStreamResponseListener.this.lock;
                synchronized (object) {
                    DeferredContentProvider.Chunk chunk;
                    while (true) {
                        if ((chunk = (DeferredContentProvider.Chunk)InputStreamResponseListener.this.chunks.peek()) == EOF) {
                            return -1;
                        }
                        if (chunk != null) break;
                        if (InputStreamResponseListener.this.failure != null) {
                            throw this.toIOException(InputStreamResponseListener.this.failure);
                        }
                        if (InputStreamResponseListener.this.closed) {
                            throw new AsynchronousCloseException();
                        }
                        InputStreamResponseListener.this.lock.wait();
                    }
                    ByteBuffer byteBuffer = chunk.buffer;
                    n3 = Math.min(byteBuffer.remaining(), n2);
                    byteBuffer.get(byArray, n, n3);
                    if (!byteBuffer.hasRemaining()) {
                        callback = chunk.callback;
                        InputStreamResponseListener.this.chunks.poll();
                    }
                }
                if (callback != null) {
                    callback.succeeded();
                }
                return n3;
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }

        private IOException toIOException(Throwable throwable) {
            if (throwable instanceof IOException) {
                return (IOException)throwable;
            }
            return new IOException(throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            List list;
            Object object = InputStreamResponseListener.this.lock;
            synchronized (object) {
                if (InputStreamResponseListener.this.closed) {
                    return;
                }
                InputStreamResponseListener.this.closed = true;
                list = InputStreamResponseListener.this.drain();
                InputStreamResponseListener.this.lock.notifyAll();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("InputStream close", new Object[0]);
            }
            object = new AsynchronousCloseException();
            list.forEach(arg_0 -> Input.lambda$close$0((Throwable)object, arg_0));
            super.close();
        }

        private static /* synthetic */ void lambda$close$0(Throwable throwable, Callback callback) {
            callback.failed(throwable);
        }
    }
}

