/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jetty.client.util.AbstractTypedContentProvider;

public class BytesContentProvider
extends AbstractTypedContentProvider {
    private final byte[][] bytes;
    private final long length;

    public BytesContentProvider(byte[] ... byArray) {
        this("application/octet-stream", byArray);
    }

    public BytesContentProvider(String string, byte[] ... byArray) {
        super(string);
        this.bytes = byArray;
        long l = 0L;
        for (byte[] byArray2 : byArray) {
            l += (long)byArray2.length;
        }
        this.length = l;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public boolean isReproducible() {
        return true;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new Iterator<ByteBuffer>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < BytesContentProvider.this.bytes.length;
            }

            @Override
            public ByteBuffer next() {
                try {
                    return ByteBuffer.wrap(BytesContentProvider.this.bytes[this.index++]);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
            }
        };
    }
}

