/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public abstract class ProxyProtocolClientConnectionFactory
implements ClientConnectionFactory {
    private final ClientConnectionFactory factory;

    private ProxyProtocolClientConnectionFactory(ClientConnectionFactory clientConnectionFactory) {
        this.factory = clientConnectionFactory;
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.factory;
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> map) {
        ProxyProtocolConnection proxyProtocolConnection = this.newProxyProtocolConnection(endPoint, map);
        return this.customize(proxyProtocolConnection, map);
    }

    protected abstract ProxyProtocolConnection newProxyProtocolConnection(EndPoint var1, Map<String, Object> var2);

    private static class ProxyProtocolConnectionV2
    extends ProxyProtocolConnection {
        private static final byte[] MAGIC = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10};
        private final V2.Tag tag;

        public ProxyProtocolConnectionV2(EndPoint endPoint, Executor executor, ClientConnectionFactory clientConnectionFactory, Map<String, Object> map, V2.Tag tag) {
            super(endPoint, executor, clientConnectionFactory, map);
            this.tag = tag;
        }

        @Override
        protected void writePROXYBytes(EndPoint endPoint, Callback callback) {
            try {
                int n;
                V2.Tag.Protocol protocol;
                int n2;
                int n3 = MAGIC.length;
                ++n3;
                ++n3;
                n3 += 2;
                n3 += 216;
                List<V2.Tag.TLV> list = this.tag.getTLVs();
                int n4 = list == null ? 0 : list.stream().mapToInt(tLV -> 3 + tLV.getValue().length).sum();
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n3 += n4);
                byteBuffer.put(MAGIC);
                V2.Tag.Command command = this.tag.getCommand();
                int n5 = 0x20 | command.ordinal() & 0xF;
                byteBuffer.put((byte)n5);
                V2.Tag.Family family = this.tag.getFamily();
                String string = this.tag.getSourceAddress();
                if (string == null) {
                    string = endPoint.getLocalAddress().getAddress().getHostAddress();
                }
                if ((n2 = this.tag.getSourcePort()) <= 0) {
                    n2 = endPoint.getLocalAddress().getPort();
                }
                if (family == null) {
                    V2.Tag.Family family2 = family = InetAddress.getByName(string) instanceof Inet4Address ? V2.Tag.Family.INET4 : V2.Tag.Family.INET6;
                }
                if ((protocol = this.tag.getProtocol()) == null) {
                    protocol = V2.Tag.Protocol.STREAM;
                }
                int n6 = family.ordinal() << 4 | protocol.ordinal();
                byteBuffer.put((byte)n6);
                int n7 = 0;
                switch (family) {
                    case UNSPEC: {
                        break;
                    }
                    case INET4: {
                        n7 = 12;
                        break;
                    }
                    case INET6: {
                        n7 = 36;
                        break;
                    }
                    case UNIX: {
                        n7 = 216;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                byteBuffer.putShort((short)(n7 += n4));
                String string2 = this.tag.getDestinationAddress();
                if (string2 == null) {
                    string2 = endPoint.getRemoteAddress().getAddress().getHostAddress();
                }
                if ((n = this.tag.getDestinationPort()) <= 0) {
                    n = endPoint.getRemoteAddress().getPort();
                }
                switch (family) {
                    case UNSPEC: {
                        break;
                    }
                    case INET4: 
                    case INET6: {
                        byteBuffer.put(InetAddress.getByName(string).getAddress());
                        byteBuffer.put(InetAddress.getByName(string2).getAddress());
                        byteBuffer.putShort((short)n2);
                        byteBuffer.putShort((short)n);
                        break;
                    }
                    case UNIX: {
                        int n8 = byteBuffer.position();
                        byteBuffer.put(string.getBytes(StandardCharsets.US_ASCII));
                        byteBuffer.position(n8 + 108);
                        byteBuffer.put(string2.getBytes(StandardCharsets.US_ASCII));
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (list != null) {
                    for (V2.Tag.TLV tLV2 : list) {
                        byteBuffer.put((byte)tLV2.getType());
                        byte[] byArray = tLV2.getValue();
                        byteBuffer.putShort((short)byArray.length);
                        byteBuffer.put(byArray);
                    }
                }
                byteBuffer.flip();
                endPoint.write(callback, byteBuffer);
            }
            catch (Throwable throwable) {
                callback.failed(throwable);
            }
        }
    }

    private static class ProxyProtocolConnectionV1
    extends ProxyProtocolConnection {
        private final V1.Tag tag;

        public ProxyProtocolConnectionV1(EndPoint endPoint, Executor executor, ClientConnectionFactory clientConnectionFactory, Map<String, Object> map, V1.Tag tag) {
            super(endPoint, executor, clientConnectionFactory, map);
            this.tag = tag;
        }

        @Override
        protected void writePROXYBytes(EndPoint endPoint, Callback callback) {
            try {
                InetSocketAddress inetSocketAddress = endPoint.getLocalAddress();
                InetSocketAddress inetSocketAddress2 = endPoint.getRemoteAddress();
                String string = this.tag.getFamily();
                String string2 = this.tag.getSourceAddress();
                int n = this.tag.getSourcePort();
                String string3 = this.tag.getDestinationAddress();
                int n2 = this.tag.getDestinationPort();
                if (string == null) {
                    string = inetSocketAddress.getAddress() instanceof Inet4Address ? "TCP4" : "TCP6";
                }
                string = string.toUpperCase(Locale.ENGLISH);
                boolean bl = string.equals("UNKNOWN");
                StringBuilder stringBuilder = new StringBuilder(64);
                stringBuilder.append("PROXY ").append(string);
                if (!bl) {
                    if (string2 == null) {
                        string2 = inetSocketAddress.getAddress().getHostAddress();
                    }
                    stringBuilder.append(" ").append(string2);
                    if (string3 == null) {
                        string3 = inetSocketAddress2.getAddress().getHostAddress();
                    }
                    stringBuilder.append(" ").append(string3);
                    if (n <= 0) {
                        n = inetSocketAddress.getPort();
                    }
                    stringBuilder.append(" ").append(n);
                    if (n2 <= 0) {
                        n2 = inetSocketAddress2.getPort();
                    }
                    stringBuilder.append(" ").append(n2);
                }
                stringBuilder.append("\r\n");
                String string4 = stringBuilder.toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Writing PROXY bytes: {}", string4.trim());
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(string4.getBytes(StandardCharsets.US_ASCII));
                endPoint.write(callback, byteBuffer);
            }
            catch (Throwable throwable) {
                callback.failed(throwable);
            }
        }
    }

    protected static abstract class ProxyProtocolConnection
    extends AbstractConnection
    implements Callback {
        protected static final Logger LOG = Log.getLogger(ProxyProtocolConnection.class);
        private final ClientConnectionFactory factory;
        private final Map<String, Object> context;

        private ProxyProtocolConnection(EndPoint endPoint, Executor executor, ClientConnectionFactory clientConnectionFactory, Map<String, Object> map) {
            super(endPoint, executor);
            this.factory = clientConnectionFactory;
            this.context = map;
        }

        @Override
        public void onOpen() {
            super.onOpen();
            this.writePROXYBytes(this.getEndPoint(), this);
        }

        protected abstract void writePROXYBytes(EndPoint var1, Callback var2);

        @Override
        public void succeeded() {
            try {
                EndPoint endPoint = this.getEndPoint();
                Connection connection = this.factory.newConnection(endPoint, this.context);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Written PROXY line, upgrading to {}", connection);
                }
                endPoint.upgrade(connection);
            }
            catch (Throwable throwable) {
                this.failed(throwable);
            }
        }

        @Override
        public void failed(Throwable throwable) {
            this.close();
            Promise promise = (Promise)this.context.get("http.connection.promise");
            promise.failed(throwable);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }

        @Override
        public void onFillable() {
        }
    }

    public static class V2
    extends ProxyProtocolClientConnectionFactory {
        public V2(ClientConnectionFactory clientConnectionFactory) {
            super(clientConnectionFactory);
        }

        @Override
        protected ProxyProtocolConnection newProxyProtocolConnection(EndPoint endPoint, Map<String, Object> map) {
            HttpDestination httpDestination = (HttpDestination)map.get("http.destination");
            Executor executor = httpDestination.getHttpClient().getExecutor();
            Tag tag = (Tag)httpDestination.getOrigin().getTag();
            if (tag == null) {
                InetSocketAddress inetSocketAddress = endPoint.getLocalAddress();
                InetSocketAddress inetSocketAddress2 = endPoint.getRemoteAddress();
                boolean bl = inetSocketAddress.getAddress() instanceof Inet4Address;
                tag = new Tag(Tag.Command.PROXY, bl ? Tag.Family.INET4 : Tag.Family.INET6, Tag.Protocol.STREAM, inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort(), inetSocketAddress2.getAddress().getHostAddress(), inetSocketAddress2.getPort(), null);
            }
            return new ProxyProtocolConnectionV2(endPoint, executor, this.getClientConnectionFactory(), map, tag);
        }

        public static class Tag
        implements ClientConnectionFactory.Decorator {
            public static final Tag LOCAL = new Tag(Command.LOCAL, Family.UNSPEC, Protocol.UNSPEC, null, 0, null, 0, null);
            private Command command;
            private Family family;
            private Protocol protocol;
            private String srcIP;
            private int srcPort;
            private String dstIP;
            private int dstPort;
            private List<TLV> tlvs;

            public Tag() {
                this(null, 0);
            }

            public Tag(String string, int n) {
                this(Command.PROXY, null, Protocol.STREAM, string, n, null, 0, null);
            }

            public Tag(String string, int n, List<TLV> list) {
                this(Command.PROXY, null, Protocol.STREAM, string, n, null, 0, list);
            }

            public Tag(Command command, Family family, Protocol protocol, String string, int n, String string2, int n2, List<TLV> list) {
                this.command = command;
                this.family = family;
                this.protocol = protocol;
                this.srcIP = string;
                this.srcPort = n;
                this.dstIP = string2;
                this.dstPort = n2;
                this.tlvs = list;
            }

            public Command getCommand() {
                return this.command;
            }

            public Family getFamily() {
                return this.family;
            }

            public Protocol getProtocol() {
                return this.protocol;
            }

            public String getSourceAddress() {
                return this.srcIP;
            }

            public int getSourcePort() {
                return this.srcPort;
            }

            public String getDestinationAddress() {
                return this.dstIP;
            }

            public int getDestinationPort() {
                return this.dstPort;
            }

            public List<TLV> getTLVs() {
                return this.tlvs;
            }

            @Override
            public ClientConnectionFactory apply(ClientConnectionFactory clientConnectionFactory) {
                return new V2(clientConnectionFactory);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Tag tag = (Tag)object;
                return this.command == tag.command && this.family == tag.family && this.protocol == tag.protocol && Objects.equals(this.srcIP, tag.srcIP) && this.srcPort == tag.srcPort && Objects.equals(this.dstIP, tag.dstIP) && this.dstPort == tag.dstPort && Objects.equals(this.tlvs, tag.tlvs);
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.command, this.family, this.protocol, this.srcIP, this.srcPort, this.dstIP, this.dstPort, this.tlvs});
            }

            public static class TLV {
                private final int type;
                private final byte[] value;

                public TLV(int n, byte[] byArray) {
                    if (n < 0 || n > 255) {
                        throw new IllegalArgumentException("Invalid type: " + n);
                    }
                    if (byArray != null && byArray.length > 65535) {
                        throw new IllegalArgumentException("Invalid value length: " + byArray.length);
                    }
                    this.type = n;
                    this.value = Objects.requireNonNull(byArray);
                }

                public int getType() {
                    return this.type;
                }

                public byte[] getValue() {
                    return this.value;
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    TLV tLV = (TLV)object;
                    return this.type == tLV.type && Arrays.equals(this.value, tLV.value);
                }

                public int hashCode() {
                    int n = Objects.hash(this.type);
                    n = 31 * n + Arrays.hashCode(this.value);
                    return n;
                }
            }

            public static enum Protocol {
                UNSPEC,
                STREAM,
                DGRAM;

            }

            public static enum Family {
                UNSPEC,
                INET4,
                INET6,
                UNIX;

            }

            public static enum Command {
                LOCAL,
                PROXY;

            }
        }
    }

    public static class V1
    extends ProxyProtocolClientConnectionFactory {
        public V1(ClientConnectionFactory clientConnectionFactory) {
            super(clientConnectionFactory);
        }

        @Override
        protected ProxyProtocolConnection newProxyProtocolConnection(EndPoint endPoint, Map<String, Object> map) {
            HttpDestination httpDestination = (HttpDestination)map.get("http.destination");
            Executor executor = httpDestination.getHttpClient().getExecutor();
            Tag tag = (Tag)httpDestination.getOrigin().getTag();
            if (tag == null) {
                InetSocketAddress inetSocketAddress = endPoint.getLocalAddress();
                InetSocketAddress inetSocketAddress2 = endPoint.getRemoteAddress();
                boolean bl = inetSocketAddress.getAddress() instanceof Inet4Address;
                tag = new Tag(bl ? "TCP4" : "TCP6", inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort(), inetSocketAddress2.getAddress().getHostAddress(), inetSocketAddress2.getPort());
            }
            return new ProxyProtocolConnectionV1(endPoint, executor, this.getClientConnectionFactory(), map, tag);
        }

        public static class Tag
        implements ClientConnectionFactory.Decorator {
            public static final Tag UNKNOWN = new Tag("UNKNOWN", null, 0, null, 0);
            private final String family;
            private final String srcIP;
            private final int srcPort;
            private final String dstIP;
            private final int dstPort;

            public Tag() {
                this(null, 0);
            }

            public Tag(String string, int n) {
                this(null, string, n, null, 0);
            }

            public Tag(String string, String string2, int n, String string3, int n2) {
                this.family = string;
                this.srcIP = string2;
                this.srcPort = n;
                this.dstIP = string3;
                this.dstPort = n2;
            }

            public String getFamily() {
                return this.family;
            }

            public String getSourceAddress() {
                return this.srcIP;
            }

            public int getSourcePort() {
                return this.srcPort;
            }

            public String getDestinationAddress() {
                return this.dstIP;
            }

            public int getDestinationPort() {
                return this.dstPort;
            }

            @Override
            public ClientConnectionFactory apply(ClientConnectionFactory clientConnectionFactory) {
                return new V1(clientConnectionFactory);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Tag tag = (Tag)object;
                return Objects.equals(this.family, tag.family) && Objects.equals(this.srcIP, tag.srcIP) && this.srcPort == tag.srcPort && Objects.equals(this.dstIP, tag.dstIP) && this.dstPort == tag.dstPort;
            }

            public int hashCode() {
                return Objects.hash(this.family, this.srcIP, this.srcPort, this.dstIP, this.dstPort);
            }
        }
    }
}

