/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpRedirector {
    private static final Logger LOG = Log.getLogger(HttpRedirector.class);
    private static final String SCHEME_REGEXP = "(^https?)";
    private static final String AUTHORITY_REGEXP = "([^/?#]+)";
    private static final String DESTINATION_REGEXP = "((^https?)://([^/?#]+))?";
    private static final String PATH_REGEXP = "([^?#]*)";
    private static final String QUERY_REGEXP = "([^#]*)";
    private static final String FRAGMENT_REGEXP = "(.*)";
    private static final Pattern URI_PATTERN = Pattern.compile("((^https?)://([^/?#]+))?([^?#]*)([^#]*)(.*)");
    private static final String ATTRIBUTE = HttpRedirector.class.getName() + ".redirects";
    private final HttpClient client;
    private final ResponseNotifier notifier;

    public HttpRedirector(HttpClient httpClient) {
        this.client = httpClient;
        this.notifier = new ResponseNotifier();
    }

    public boolean isRedirect(Response response) {
        switch (response.getStatus()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    public Result redirect(Request request, Response response) throws InterruptedException, ExecutionException {
        final AtomicReference atomicReference = new AtomicReference();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Request request2 = this.redirect(request, response, new BufferingResponseListener(){

            @Override
            public void onComplete(Result result) {
                atomicReference.set(new Result(result.getRequest(), result.getRequestFailure(), new HttpContentResponse(result.getResponse(), this.getContent(), this.getMediaType(), this.getEncoding()), result.getResponseFailure()));
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
            Result result = (Result)atomicReference.get();
            if (result.isFailed()) {
                throw new ExecutionException(result.getFailure());
            }
            return result;
        }
        catch (InterruptedException interruptedException) {
            request2.abort(interruptedException);
            throw interruptedException;
        }
    }

    public Request redirect(Request request, Response response, Response.CompleteListener completeListener) {
        if (this.isRedirect(response)) {
            String string = response.getHeaders().get("Location");
            URI uRI = this.extractRedirectURI(response);
            if (uRI != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Redirecting to {} (Location: {})", uRI, string);
                }
                return this.redirect(request, response, completeListener, uRI);
            }
            this.fail(request, response, new HttpResponseException("Invalid 'Location' header: " + string, response));
            return null;
        }
        this.fail(request, response, new HttpResponseException("Cannot redirect: " + response, response));
        return null;
    }

    public URI extractRedirectURI(Response response) {
        String string = response.getHeaders().get("location");
        if (string != null) {
            return this.sanitize(string);
        }
        return null;
    }

    private URI sanitize(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            Matcher matcher = URI_PATTERN.matcher(string);
            if (matcher.matches()) {
                String string2;
                String string3 = matcher.group(2);
                String string4 = matcher.group(3);
                String string5 = matcher.group(4);
                String string6 = matcher.group(5);
                if (string6.length() == 0) {
                    string6 = null;
                }
                if ((string2 = matcher.group(6)).length() == 0) {
                    string2 = null;
                }
                try {
                    return new URI(string3, string4, string5, string6, string2);
                }
                catch (URISyntaxException uRISyntaxException2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private Request redirect(Request request, Response response, Response.CompleteListener completeListener, URI uRI) {
        String string;
        if (!uRI.isAbsolute()) {
            URI uRI2 = request.getURI();
            if (uRI2 == null) {
                string = request.getScheme() + "://" + request.getHost();
                int n = request.getPort();
                if (n > 0) {
                    string = string + ":" + n;
                }
                uRI2 = URI.create(string);
            }
            uRI = uRI2.resolve(uRI);
        }
        int n = response.getStatus();
        switch (n) {
            case 301: {
                string = request.getMethod();
                if (HttpMethod.GET.is(string) || HttpMethod.HEAD.is(string) || HttpMethod.PUT.is(string)) {
                    return this.redirect(request, response, completeListener, uRI, string);
                }
                if (HttpMethod.POST.is(string)) {
                    return this.redirect(request, response, completeListener, uRI, HttpMethod.GET.asString());
                }
                this.fail(request, response, new HttpResponseException("HTTP protocol violation: received 301 for non GET/HEAD/POST/PUT request", response));
                return null;
            }
            case 302: {
                string = request.getMethod();
                if (HttpMethod.HEAD.is(string) || HttpMethod.PUT.is(string)) {
                    return this.redirect(request, response, completeListener, uRI, string);
                }
                return this.redirect(request, response, completeListener, uRI, HttpMethod.GET.asString());
            }
            case 303: {
                string = request.getMethod();
                if (HttpMethod.HEAD.is(string)) {
                    return this.redirect(request, response, completeListener, uRI, string);
                }
                return this.redirect(request, response, completeListener, uRI, HttpMethod.GET.asString());
            }
            case 307: 
            case 308: {
                return this.redirect(request, response, completeListener, uRI, request.getMethod());
            }
        }
        this.fail(request, response, new HttpResponseException("Unhandled HTTP status code " + n, response));
        return null;
    }

    private Request redirect(Request request, Response response, Response.CompleteListener completeListener, URI uRI, String string) {
        int n;
        HttpRequest httpRequest = (HttpRequest)request;
        HttpConversation httpConversation = httpRequest.getConversation();
        Integer n2 = (Integer)httpConversation.getAttribute(ATTRIBUTE);
        if (n2 == null) {
            n2 = 0;
        }
        if ((n = this.client.getMaxRedirects()) < 0 || n2 < n) {
            n2 = n2 + 1;
            httpConversation.setAttribute(ATTRIBUTE, n2);
            return this.sendRedirect(httpRequest, response, completeListener, uRI, string);
        }
        this.fail(request, response, new HttpResponseException("Max redirects exceeded " + n2, response));
        return null;
    }

    private Request sendRedirect(HttpRequest httpRequest, Response response, Response.CompleteListener completeListener, URI uRI, String string) {
        try {
            Request request2 = this.client.copyRequest(httpRequest, uRI);
            long l = httpRequest.getTimeoutAt();
            if (l < Long.MAX_VALUE) {
                long l2 = l - System.nanoTime();
                if (l2 > 0L) {
                    request2.timeout(l2, TimeUnit.NANOSECONDS);
                } else {
                    TimeoutException timeoutException = new TimeoutException("Total timeout " + httpRequest.getConversation().getTimeout() + " ms elapsed");
                    this.fail((Request)httpRequest, timeoutException, response);
                    return null;
                }
            }
            request2.method(string);
            request2.onRequestBegin(request -> {
                Throwable throwable = httpRequest.getAbortCause();
                if (throwable != null) {
                    request.abort(throwable);
                }
            });
            request2.send(completeListener);
            return request2;
        }
        catch (Throwable throwable) {
            this.fail((Request)httpRequest, throwable, response);
            return null;
        }
    }

    protected void fail(Request request, Response response, Throwable throwable) {
        this.fail(request, null, response, throwable);
    }

    protected void fail(Request request, Throwable throwable, Response response) {
        this.fail(request, throwable, response, throwable);
    }

    private void fail(Request request, Throwable throwable, Response response, Throwable throwable2) {
        HttpConversation httpConversation = ((HttpRequest)request).getConversation();
        httpConversation.updateResponseListeners(null);
        List<Response.ResponseListener> list = httpConversation.getResponseListeners();
        this.notifier.notifyFailure(list, response, throwable2);
        this.notifier.notifyComplete(list, new Result(request, throwable, response, throwable2));
    }
}

