/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;

public class HttpContentResponse
implements ContentResponse {
    private final Response response;
    private final byte[] content;
    private final String mediaType;
    private final String encoding;

    public HttpContentResponse(Response response, byte[] byArray, String string, String string2) {
        this.response = response;
        this.content = byArray;
        this.mediaType = string;
        this.encoding = string2;
    }

    @Override
    public Request getRequest() {
        return this.response.getRequest();
    }

    @Override
    public <T extends Response.ResponseListener> List<T> getListeners(Class<T> clazz) {
        return this.response.getListeners(clazz);
    }

    @Override
    public HttpVersion getVersion() {
        return this.response.getVersion();
    }

    @Override
    public int getStatus() {
        return this.response.getStatus();
    }

    @Override
    public String getReason() {
        return this.response.getReason();
    }

    @Override
    public HttpFields getHeaders() {
        return this.response.getHeaders();
    }

    @Override
    public boolean abort(Throwable throwable) {
        return this.response.abort(throwable);
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public String getContentAsString() {
        String string = this.encoding;
        if (string == null) {
            return new String(this.getContent(), StandardCharsets.UTF_8);
        }
        try {
            return new String(this.getContent(), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharsetException(string);
        }
    }

    public String toString() {
        return String.format("%s[%s %d %s - %d bytes]", new Object[]{HttpContentResponse.class.getSimpleName(), this.getVersion(), this.getStatus(), this.getReason(), this.getContent().length});
    }
}

