/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.client.ContinueProtocolHandler;
import org.eclipse.jetty.client.GZIPContentDecoder;
import org.eclipse.jetty.client.HttpAuthenticationStore;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ProtocolHandlers;
import org.eclipse.jetty.client.ProxyAuthenticationProtocolHandler;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.RedirectProtocolHandler;
import org.eclipse.jetty.client.WWWAuthenticationProtocolHandler;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.util.FormContentProvider;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.Jetty;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.SocketAddressResolver;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.Sweeper;
import org.eclipse.jetty.util.thread.ThreadPool;

@ManagedObject(value="The HTTP client")
public class HttpClient
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(HttpClient.class);
    private final ConcurrentMap<Origin, HttpDestination> destinations = new ConcurrentHashMap<Origin, HttpDestination>();
    private final ProtocolHandlers handlers = new ProtocolHandlers();
    private final List<Request.Listener> requestListeners = new ArrayList<Request.Listener>();
    private final Set<ContentDecoder.Factory> decoderFactories = new ContentDecoderFactorySet();
    private final ProxyConfiguration proxyConfig = new ProxyConfiguration();
    private final HttpClientTransport transport;
    private final SslContextFactory sslContextFactory;
    private AuthenticationStore authenticationStore = new HttpAuthenticationStore();
    private CookieManager cookieManager;
    private CookieStore cookieStore;
    private Executor executor;
    private ByteBufferPool byteBufferPool;
    private Scheduler scheduler;
    private SocketAddressResolver resolver;
    private HttpField agentField = new HttpField(HttpHeader.USER_AGENT, "Jetty/" + Jetty.VERSION);
    private boolean followRedirects = true;
    private int maxConnectionsPerDestination = 64;
    private int maxRequestsQueuedPerDestination = 1024;
    private int requestBufferSize = 4096;
    private int responseBufferSize = 16384;
    private int maxRedirects = 8;
    private SocketAddress bindAddress;
    private long connectTimeout = 15000L;
    private long addressResolutionTimeout = 15000L;
    private long idleTimeout;
    private boolean tcpNoDelay = true;
    private boolean strictEventOrdering = false;
    private HttpField encodingField;
    private long destinationIdleTimeout;
    private boolean connectBlocking = false;
    private String name = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    private HttpCompliance httpCompliance = HttpCompliance.RFC7230;
    private String defaultRequestContentType = "application/octet-stream";
    private Sweeper destinationSweeper;

    public HttpClient() {
        this(new HttpClientTransportOverHTTP(), null);
    }

    public HttpClient(SslContextFactory sslContextFactory) {
        this(new HttpClientTransportOverHTTP(), sslContextFactory);
    }

    public HttpClient(HttpClientTransport httpClientTransport) {
        this(httpClientTransport, null);
    }

    public HttpClient(HttpClientTransport httpClientTransport, SslContextFactory sslContextFactory) {
        this.transport = httpClientTransport;
        this.addBean(httpClientTransport);
        this.sslContextFactory = sslContextFactory;
        this.addBean(sslContextFactory);
        this.addBean(this.handlers);
        this.addBean(this.decoderFactories);
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        this.dumpObjects(appendable, string, new DumpableCollection("requestListeners", this.requestListeners));
    }

    public HttpClientTransport getTransport() {
        return this.transport;
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.executor == null) {
            QueuedThreadPool queuedThreadPool = new QueuedThreadPool();
            queuedThreadPool.setName(this.name);
            this.setExecutor(queuedThreadPool);
        }
        if (this.byteBufferPool == null) {
            this.setByteBufferPool(new MappedByteBufferPool(2048, this.executor instanceof ThreadPool.SizedThreadPool ? ((ThreadPool.SizedThreadPool)this.executor).getMaxThreads() / 2 : ProcessorUtils.availableProcessors() * 2));
        }
        if (this.scheduler == null) {
            this.setScheduler(new ScheduledExecutorScheduler(this.name + "-scheduler", false));
        }
        if (this.resolver == null) {
            this.setSocketAddressResolver(new SocketAddressResolver.Async(this.executor, this.scheduler, this.getAddressResolutionTimeout()));
        }
        this.handlers.put(new ContinueProtocolHandler());
        this.handlers.put(new RedirectProtocolHandler(this));
        this.handlers.put(new WWWAuthenticationProtocolHandler(this));
        this.handlers.put(new ProxyAuthenticationProtocolHandler(this));
        this.decoderFactories.add(new GZIPContentDecoder.Factory(this.byteBufferPool));
        this.cookieManager = this.newCookieManager();
        this.cookieStore = this.cookieManager.getCookieStore();
        this.transport.setHttpClient(this);
        super.doStart();
        if (this.getDestinationIdleTimeout() > 0L) {
            this.destinationSweeper = new Sweeper(this.scheduler, 1000L);
            this.destinationSweeper.start();
        }
    }

    private CookieManager newCookieManager() {
        return new CookieManager(this.getCookieStore(), CookiePolicy.ACCEPT_ALL);
    }

    @Override
    protected void doStop() throws Exception {
        if (this.destinationSweeper != null) {
            this.destinationSweeper.stop();
            this.destinationSweeper = null;
        }
        this.decoderFactories.clear();
        this.handlers.clear();
        for (HttpDestination httpDestination : this.destinations.values()) {
            httpDestination.close();
        }
        this.destinations.clear();
        this.requestListeners.clear();
        this.authenticationStore.clearAuthentications();
        this.authenticationStore.clearAuthenticationResults();
        super.doStop();
    }

    public List<Request.Listener> getRequestListeners() {
        return this.requestListeners;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = Objects.requireNonNull(cookieStore);
        this.cookieManager = this.newCookieManager();
    }

    CookieManager getCookieManager() {
        return this.cookieManager;
    }

    Sweeper getDestinationSweeper() {
        return this.destinationSweeper;
    }

    public AuthenticationStore getAuthenticationStore() {
        return this.authenticationStore;
    }

    public void setAuthenticationStore(AuthenticationStore authenticationStore) {
        this.authenticationStore = authenticationStore;
    }

    public Set<ContentDecoder.Factory> getContentDecoderFactories() {
        return this.decoderFactories;
    }

    public ContentResponse GET(String string) throws InterruptedException, ExecutionException, TimeoutException {
        return this.GET(URI.create(string));
    }

    public ContentResponse GET(URI uRI) throws InterruptedException, ExecutionException, TimeoutException {
        return this.newRequest(uRI).send();
    }

    public ContentResponse FORM(String string, Fields fields) throws InterruptedException, ExecutionException, TimeoutException {
        return this.FORM(URI.create(string), fields);
    }

    public ContentResponse FORM(URI uRI, Fields fields) throws InterruptedException, ExecutionException, TimeoutException {
        return this.POST(uRI).content(new FormContentProvider(fields)).send();
    }

    public Request POST(String string) {
        return this.POST(URI.create(string));
    }

    public Request POST(URI uRI) {
        return this.newRequest(uRI).method(HttpMethod.POST);
    }

    public Request newRequest(String string, int n) {
        return this.newRequest(new Origin("http", string, n).asString());
    }

    public Request newRequest(String string) {
        return this.newRequest(URI.create(string));
    }

    public Request newRequest(URI uRI) {
        return this.newHttpRequest(this.newConversation(), uRI);
    }

    protected Request copyRequest(HttpRequest httpRequest, URI uRI) {
        HttpRequest httpRequest2 = this.newHttpRequest(httpRequest.getConversation(), uRI);
        httpRequest2.method(httpRequest.getMethod()).version(httpRequest.getVersion()).content(httpRequest.getContent()).idleTimeout(httpRequest.getIdleTimeout(), TimeUnit.MILLISECONDS).timeout(httpRequest.getTimeout(), TimeUnit.MILLISECONDS).followRedirects(httpRequest.isFollowRedirects());
        for (HttpField httpField : httpRequest.getHeaders()) {
            HttpHeader httpHeader = httpField.getHeader();
            if (HttpHeader.HOST == httpHeader || HttpHeader.EXPECT == httpHeader || HttpHeader.COOKIE == httpHeader || HttpHeader.AUTHORIZATION == httpHeader || HttpHeader.PROXY_AUTHORIZATION == httpHeader) continue;
            String string = httpField.getName();
            String string2 = httpField.getValue();
            if (httpRequest2.getHeaders().contains(string, string2)) continue;
            httpRequest2.header(string, string2);
        }
        return httpRequest2;
    }

    protected HttpRequest newHttpRequest(HttpConversation httpConversation, URI uRI) {
        return new HttpRequest(this, httpConversation, this.checkHost(uRI));
    }

    private URI checkHost(URI uRI) {
        if (uRI.getHost() == null) {
            throw new IllegalArgumentException(String.format("Invalid URI host: null (authority: %s)", uRI.getRawAuthority()));
        }
        return uRI;
    }

    public Destination getDestination(String string, String string2, int n) {
        return this.destinationFor(string, string2, n);
    }

    protected HttpDestination destinationFor(String string, String string2, int n) {
        return this.resolveDestination(string, string2, n, null);
    }

    protected HttpDestination resolveDestination(String string, String string2, int n, Object object) {
        Origin origin = this.createOrigin(string, string2, n, object);
        return this.resolveDestination(origin);
    }

    protected Origin createOrigin(String string, String string2, int n, Object object) {
        if (!(HttpScheme.HTTP.is(string) || HttpScheme.HTTPS.is(string) || HttpScheme.WS.is(string) || HttpScheme.WSS.is(string))) {
            throw new IllegalArgumentException("Invalid protocol " + string);
        }
        string = string.toLowerCase(Locale.ENGLISH);
        string2 = string2.toLowerCase(Locale.ENGLISH);
        n = HttpClient.normalizePort(string, n);
        return new Origin(string, string2, n, object);
    }

    public HttpDestination resolveDestination(Origin origin2) {
        return this.destinations.compute(origin2, (origin, httpDestination) -> {
            if (httpDestination == null || httpDestination.stale()) {
                HttpDestination httpDestination2 = this.getTransport().newHttpDestination((Origin)origin);
                this.addManaged(httpDestination2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Created {}; existing: '{}'", httpDestination2, httpDestination);
                }
                return httpDestination2;
            }
            return httpDestination;
        });
    }

    protected boolean removeDestination(HttpDestination httpDestination) {
        boolean bl = this.destinations.remove(httpDestination.getOrigin(), httpDestination);
        this.removeBean(httpDestination);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removed {}; result: {}", httpDestination, bl);
        }
        return bl;
    }

    public List<Destination> getDestinations() {
        return new ArrayList<Destination>(this.destinations.values());
    }

    protected void send(HttpRequest httpRequest, List<Response.ResponseListener> list) {
        HttpDestination httpDestination = this.resolveDestination(httpRequest.getScheme(), httpRequest.getHost(), httpRequest.getPort(), httpRequest.getTag());
        httpDestination.send(httpRequest, list);
    }

    protected void newConnection(final HttpDestination httpDestination, final Promise<Connection> promise) {
        Origin.Address address = httpDestination.getConnectAddress();
        this.resolver.resolve(address.getHost(), address.getPort(), new Promise<List<InetSocketAddress>>(){

            @Override
            public void succeeded(List<InetSocketAddress> list) {
                ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
                concurrentHashMap.put("client.connector", HttpClient.this);
                concurrentHashMap.put("http.destination", httpDestination);
                this.connect(list, 0, concurrentHashMap);
            }

            @Override
            public void failed(Throwable throwable) {
                promise.failed(throwable);
            }

            private void connect(final List<InetSocketAddress> list, final int n, final Map<String, Object> map) {
                map.put("http.connection.promise", new Promise.Wrapper<Connection>(promise){

                    @Override
                    public void failed(Throwable throwable) {
                        int n2 = n + 1;
                        if (n2 == list.size()) {
                            super.failed(throwable);
                        } else {
                            this.connect(list, n2, map);
                        }
                    }
                });
                HttpClient.this.transport.connect(list.get(n), map);
            }
        });
    }

    private HttpConversation newConversation() {
        return new HttpConversation();
    }

    public ProtocolHandlers getProtocolHandlers() {
        return this.handlers;
    }

    protected ProtocolHandler findProtocolHandler(Request request, Response response) {
        return this.handlers.find(request, response);
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    public void setByteBufferPool(ByteBufferPool byteBufferPool) {
        if (this.isStarted()) {
            LOG.warn("Calling setByteBufferPool() while started is deprecated", new Object[0]);
        }
        this.updateBean(this.byteBufferPool, byteBufferPool);
        this.byteBufferPool = byteBufferPool;
    }

    @ManagedAttribute(value="The name of this HttpClient")
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @ManagedAttribute(value="The timeout, in milliseconds, for connect() operations")
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long l) {
        this.connectTimeout = l;
    }

    public long getAddressResolutionTimeout() {
        return this.addressResolutionTimeout;
    }

    public void setAddressResolutionTimeout(long l) {
        this.addressResolutionTimeout = l;
    }

    @ManagedAttribute(value="The timeout, in milliseconds, to close idle connections")
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long l) {
        this.idleTimeout = l;
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(SocketAddress socketAddress) {
        this.bindAddress = socketAddress;
    }

    public HttpField getUserAgentField() {
        return this.agentField;
    }

    public void setUserAgentField(HttpField httpField) {
        if (httpField != null && httpField.getHeader() != HttpHeader.USER_AGENT) {
            throw new IllegalArgumentException();
        }
        this.agentField = httpField;
    }

    @ManagedAttribute(value="Whether HTTP redirects are followed")
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean bl) {
        this.followRedirects = bl;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        if (this.isStarted()) {
            LOG.warn("Calling setExecutor() while started is deprecated", new Object[0]);
        }
        this.updateBean(this.executor, executor);
        this.executor = executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        if (this.isStarted()) {
            LOG.warn("Calling setScheduler() while started is deprecated", new Object[0]);
        }
        this.updateBean(this.scheduler, scheduler);
        this.scheduler = scheduler;
    }

    public SocketAddressResolver getSocketAddressResolver() {
        return this.resolver;
    }

    public void setSocketAddressResolver(SocketAddressResolver socketAddressResolver) {
        if (this.isStarted()) {
            LOG.warn("Calling setSocketAddressResolver() while started is deprecated", new Object[0]);
        }
        this.updateBean(this.resolver, socketAddressResolver);
        this.resolver = socketAddressResolver;
    }

    @ManagedAttribute(value="The max number of connections per each destination")
    public int getMaxConnectionsPerDestination() {
        return this.maxConnectionsPerDestination;
    }

    public void setMaxConnectionsPerDestination(int n) {
        this.maxConnectionsPerDestination = n;
    }

    @ManagedAttribute(value="The max number of requests queued per each destination")
    public int getMaxRequestsQueuedPerDestination() {
        return this.maxRequestsQueuedPerDestination;
    }

    public void setMaxRequestsQueuedPerDestination(int n) {
        this.maxRequestsQueuedPerDestination = n;
    }

    @ManagedAttribute(value="The request buffer size")
    public int getRequestBufferSize() {
        return this.requestBufferSize;
    }

    public void setRequestBufferSize(int n) {
        this.requestBufferSize = n;
    }

    @ManagedAttribute(value="The response buffer size")
    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public void setResponseBufferSize(int n) {
        this.responseBufferSize = n;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public void setMaxRedirects(int n) {
        this.maxRedirects = n;
    }

    @ManagedAttribute(value="Whether the TCP_NODELAY option is enabled", name="tcpNoDelay")
    public boolean isTCPNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTCPNoDelay(boolean bl) {
        this.tcpNoDelay = bl;
    }

    @Deprecated
    public boolean isDispatchIO() {
        return false;
    }

    @Deprecated
    public void setDispatchIO(boolean bl) {
    }

    public HttpCompliance getHttpCompliance() {
        return this.httpCompliance;
    }

    public void setHttpCompliance(HttpCompliance httpCompliance) {
        this.httpCompliance = httpCompliance;
    }

    @ManagedAttribute(value="Whether request/response events must be strictly ordered")
    public boolean isStrictEventOrdering() {
        return this.strictEventOrdering;
    }

    public void setStrictEventOrdering(boolean bl) {
        this.strictEventOrdering = bl;
    }

    @ManagedAttribute(value="The time in ms after which idle destinations are removed, disabled when zero or negative")
    public long getDestinationIdleTimeout() {
        return this.destinationIdleTimeout;
    }

    public void setDestinationIdleTimeout(long l) {
        if (this.isStarted()) {
            LOG.warn("Calling setDestinationIdleTimeout() while started has no effect", new Object[0]);
        }
        this.destinationIdleTimeout = l;
    }

    @Deprecated
    @ManagedAttribute(value="Whether idle destinations are removed")
    public boolean isRemoveIdleDestinations() {
        return this.destinationIdleTimeout > 0L;
    }

    @Deprecated
    public void setRemoveIdleDestinations(boolean bl) {
        this.setDestinationIdleTimeout(bl ? 10000L : 0L);
    }

    @ManagedAttribute(value="Whether the connect() operation is blocking")
    public boolean isConnectBlocking() {
        return this.connectBlocking;
    }

    public void setConnectBlocking(boolean bl) {
        this.connectBlocking = bl;
    }

    @ManagedAttribute(value="The default content type for request content")
    public String getDefaultRequestContentType() {
        return this.defaultRequestContentType;
    }

    public void setDefaultRequestContentType(String string) {
        this.defaultRequestContentType = string;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfig;
    }

    protected HttpField getAcceptEncodingField() {
        return this.encodingField;
    }

    @Deprecated
    protected String normalizeHost(String string) {
        return string;
    }

    public static int normalizePort(String string, int n) {
        if (n > 0) {
            return n;
        }
        if (HttpClient.isSchemeSecure(string)) {
            return 443;
        }
        return 80;
    }

    public boolean isDefaultPort(String string, int n) {
        if (HttpClient.isSchemeSecure(string)) {
            return n == 443;
        }
        return n == 80;
    }

    static boolean isSchemeSecure(String string) {
        return HttpScheme.HTTPS.is(string) || HttpScheme.WSS.is(string);
    }

    @Deprecated
    protected ClientConnectionFactory newSslClientConnectionFactory(ClientConnectionFactory clientConnectionFactory) {
        return new SslClientConnectionFactory(this.getSslContextFactory(), this.getByteBufferPool(), this.getExecutor(), clientConnectionFactory);
    }

    protected ClientConnectionFactory newSslClientConnectionFactory(SslContextFactory sslContextFactory, ClientConnectionFactory clientConnectionFactory) {
        if (sslContextFactory == null) {
            return this.newSslClientConnectionFactory(clientConnectionFactory);
        }
        return new SslClientConnectionFactory(sslContextFactory, this.getByteBufferPool(), this.getExecutor(), clientConnectionFactory);
    }

    private class ContentDecoderFactorySet
    implements Set<ContentDecoder.Factory> {
        private final Set<ContentDecoder.Factory> set = new HashSet<ContentDecoder.Factory>();

        private ContentDecoderFactorySet() {
        }

        @Override
        public boolean add(ContentDecoder.Factory factory) {
            boolean bl = this.set.add(factory);
            this.invalidate();
            return bl;
        }

        @Override
        public boolean addAll(Collection<? extends ContentDecoder.Factory> collection) {
            boolean bl = this.set.addAll(collection);
            this.invalidate();
            return bl;
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = this.set.remove(object);
            this.invalidate();
            return bl;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = this.set.removeAll(collection);
            this.invalidate();
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = this.set.retainAll(collection);
            this.invalidate();
            return bl;
        }

        @Override
        public void clear() {
            this.set.clear();
            this.invalidate();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.set.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.set.containsAll(collection);
        }

        @Override
        public Iterator<ContentDecoder.Factory> iterator() {
            final Iterator<ContentDecoder.Factory> iterator = this.set.iterator();
            return new Iterator<ContentDecoder.Factory>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public ContentDecoder.Factory next() {
                    return (ContentDecoder.Factory)iterator.next();
                }

                @Override
                public void remove() {
                    iterator.remove();
                    ContentDecoderFactorySet.this.invalidate();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.set.toArray(TArray);
        }

        private void invalidate() {
            if (this.set.isEmpty()) {
                HttpClient.this.encodingField = null;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                Iterator<ContentDecoder.Factory> iterator = this.set.iterator();
                while (iterator.hasNext()) {
                    ContentDecoder.Factory factory = iterator.next();
                    stringBuilder.append(factory.getEncoding());
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(",");
                }
                HttpClient.this.encodingField = new HttpField(HttpHeader.ACCEPT_ENCODING, stringBuilder.toString());
            }
        }
    }
}

