/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.util.List;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.tree.AbstractElement;
import org.dom4j.tree.ContentListFacade;

public class BaseElement
extends AbstractElement {
    private QName qname;
    private Branch parentBranch;
    protected List content;
    protected List attributes;

    public BaseElement(String string) {
        this.qname = this.getDocumentFactory().createQName(string);
    }

    public BaseElement(QName qName) {
        this.qname = qName;
    }

    public BaseElement(String string, Namespace namespace) {
        this.qname = this.getDocumentFactory().createQName(string, namespace);
    }

    public Element getParent() {
        Element element = null;
        if (this.parentBranch instanceof Element) {
            element = (Element)this.parentBranch;
        }
        return element;
    }

    public void setParent(Element element) {
        if (this.parentBranch instanceof Element || element != null) {
            this.parentBranch = element;
        }
    }

    public Document getDocument() {
        if (this.parentBranch instanceof Document) {
            return (Document)this.parentBranch;
        }
        if (this.parentBranch instanceof Element) {
            Element element = (Element)this.parentBranch;
            return element.getDocument();
        }
        return null;
    }

    public void setDocument(Document document) {
        if (this.parentBranch instanceof Document || document != null) {
            this.parentBranch = document;
        }
    }

    public boolean supportsParent() {
        return true;
    }

    public QName getQName() {
        return this.qname;
    }

    public void setQName(QName qName) {
        this.qname = qName;
    }

    public void clearContent() {
        this.contentList().clear();
    }

    public void setContent(List list) {
        this.content = list;
        if (list instanceof ContentListFacade) {
            this.content = ((ContentListFacade)list).getBackingList();
        }
    }

    public void setAttributes(List list) {
        this.attributes = list;
        if (list instanceof ContentListFacade) {
            this.attributes = ((ContentListFacade)list).getBackingList();
        }
    }

    protected List contentList() {
        if (this.content == null) {
            this.content = this.createContentList();
        }
        return this.content;
    }

    protected List attributeList() {
        if (this.attributes == null) {
            this.attributes = this.createAttributeList();
        }
        return this.attributes;
    }

    protected List attributeList(int n) {
        if (this.attributes == null) {
            this.attributes = this.createAttributeList(n);
        }
        return this.attributes;
    }

    protected void setAttributeList(List list) {
        this.attributes = list;
    }
}

