/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.rule;

import java.util.HashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.rule.Action;
import org.dom4j.rule.Rule;
import org.dom4j.rule.RuleSet;

public class Mode {
    private RuleSet[] ruleSets = new RuleSet[14];
    private Map elementNameRuleSets;
    private Map attributeNameRuleSets;

    public void fireRule(Node node) throws Exception {
        Action action;
        Rule rule;
        if (node != null && (rule = this.getMatchingRule(node)) != null && (action = rule.getAction()) != null) {
            action.run(node);
        }
    }

    public void applyTemplates(Element element) throws Exception {
        Node node;
        int n;
        int n2 = element.attributeCount();
        for (n = 0; n < n2; ++n) {
            node = element.attribute(n);
            this.fireRule(node);
        }
        n2 = element.nodeCount();
        for (n = 0; n < n2; ++n) {
            node = element.node(n);
            this.fireRule(node);
        }
    }

    public void applyTemplates(Document document) throws Exception {
        int n = document.nodeCount();
        for (int i = 0; i < n; ++i) {
            Node node = document.node(i);
            this.fireRule(node);
        }
    }

    public void addRule(Rule rule) {
        short s = rule.getMatchType();
        String string = rule.getMatchesNodeName();
        if (string != null) {
            if (s == 1) {
                this.elementNameRuleSets = this.addToNameMap(this.elementNameRuleSets, string, rule);
            } else if (s == 2) {
                this.attributeNameRuleSets = this.addToNameMap(this.attributeNameRuleSets, string, rule);
            }
        }
        if (s >= 14) {
            s = 0;
        }
        if (s == 0) {
            int n = this.ruleSets.length;
            for (int i = 1; i < n; ++i) {
                RuleSet ruleSet = this.ruleSets[i];
                if (ruleSet == null) continue;
                ruleSet.addRule(rule);
            }
        }
        this.getRuleSet(s).addRule(rule);
    }

    public void removeRule(Rule rule) {
        short s = rule.getMatchType();
        String string = rule.getMatchesNodeName();
        if (string != null) {
            if (s == 1) {
                this.removeFromNameMap(this.elementNameRuleSets, string, rule);
            } else if (s == 2) {
                this.removeFromNameMap(this.attributeNameRuleSets, string, rule);
            }
        }
        if (s >= 14) {
            s = 0;
        }
        this.getRuleSet(s).removeRule(rule);
        if (s != 0) {
            this.getRuleSet(0).removeRule(rule);
        }
    }

    public Rule getMatchingRule(Node node) {
        Rule rule;
        Object object;
        RuleSet ruleSet;
        short s = node.getNodeType();
        if (s == 1) {
            Rule rule2;
            if (this.elementNameRuleSets != null && (ruleSet = (RuleSet)this.elementNameRuleSets.get(object = node.getName())) != null && (rule2 = ruleSet.getMatchingRule(node)) != null) {
                return rule2;
            }
        } else if (s == 2 && this.attributeNameRuleSets != null && (ruleSet = (RuleSet)this.attributeNameRuleSets.get(object = node.getName())) != null && (rule = ruleSet.getMatchingRule(node)) != null) {
            return rule;
        }
        if (s < 0 || s >= this.ruleSets.length) {
            s = 0;
        }
        object = null;
        ruleSet = this.ruleSets[s];
        if (ruleSet != null) {
            object = ruleSet.getMatchingRule(node);
        }
        if (object == null && s != 0 && (ruleSet = this.ruleSets[0]) != null) {
            object = ruleSet.getMatchingRule(node);
        }
        return object;
    }

    protected RuleSet getRuleSet(int n) {
        RuleSet ruleSet = this.ruleSets[n];
        if (ruleSet == null) {
            RuleSet ruleSet2;
            this.ruleSets[n] = ruleSet = new RuleSet();
            if (n != 0 && (ruleSet2 = this.ruleSets[0]) != null) {
                ruleSet.addAll(ruleSet2);
            }
        }
        return ruleSet;
    }

    protected Map addToNameMap(Map hashMap, String string, Rule rule) {
        RuleSet ruleSet;
        if (hashMap == null) {
            hashMap = new HashMap<String, RuleSet>();
        }
        if ((ruleSet = (RuleSet)hashMap.get(string)) == null) {
            ruleSet = new RuleSet();
            hashMap.put(string, ruleSet);
        }
        ruleSet.addRule(rule);
        return hashMap;
    }

    protected void removeFromNameMap(Map map, String string, Rule rule) {
        RuleSet ruleSet;
        if (map != null && (ruleSet = (RuleSet)map.get(string)) != null) {
            ruleSet.removeRule(rule);
        }
    }
}

