/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.IOException;
import org.dom4j.Document;
import org.dom4j.io.DocumentInputSource;
import org.dom4j.io.SAXHelper;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SAXValidator {
    private XMLReader xmlReader;
    private ErrorHandler errorHandler;

    public SAXValidator() {
    }

    public SAXValidator(XMLReader xMLReader) {
        this.xmlReader = xMLReader;
    }

    public void validate(Document document) throws SAXException {
        if (document != null) {
            XMLReader xMLReader = this.getXMLReader();
            if (this.errorHandler != null) {
                xMLReader.setErrorHandler(this.errorHandler);
            }
            try {
                xMLReader.parse(new DocumentInputSource(document));
            }
            catch (IOException iOException) {
                throw new RuntimeException("Caught and exception that should never happen: " + iOException);
            }
        }
    }

    public XMLReader getXMLReader() throws SAXException {
        if (this.xmlReader == null) {
            this.xmlReader = this.createXMLReader();
            this.configureReader();
        }
        return this.xmlReader;
    }

    public void setXMLReader(XMLReader xMLReader) throws SAXException {
        this.xmlReader = xMLReader;
        this.configureReader();
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected XMLReader createXMLReader() throws SAXException {
        return SAXHelper.createXMLReader(true);
    }

    protected void configureReader() throws SAXException {
        ContentHandler contentHandler = this.xmlReader.getContentHandler();
        if (contentHandler == null) {
            this.xmlReader.setContentHandler(new DefaultHandler());
        }
        this.xmlReader.setFeature("http://xml.org/sax/features/validation", true);
        this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
        this.xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
    }
}

