/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.datatype;

import com.sun.msv.datatype.DatabindableDatatype;
import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.XSDatatype;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.tree.DefaultElement;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public class DatatypeElement
extends DefaultElement
implements SerializationContext,
ValidationContext {
    private XSDatatype datatype;
    private Object data;

    public DatatypeElement(QName qName, XSDatatype xSDatatype) {
        super(qName);
        this.datatype = xSDatatype;
    }

    public DatatypeElement(QName qName, int n, XSDatatype xSDatatype) {
        super(qName, n);
        this.datatype = xSDatatype;
    }

    public String toString() {
        return this.getClass().getName() + this.hashCode() + " [Element: <" + this.getQualifiedName() + " attributes: " + this.attributeList() + " data: " + this.getData() + " />]";
    }

    public XSDatatype getXSDatatype() {
        return this.datatype;
    }

    public String getNamespacePrefix(String string) {
        Namespace namespace = this.getNamespaceForURI(string);
        return namespace != null ? namespace.getPrefix() : null;
    }

    public String getBaseUri() {
        return null;
    }

    public boolean isNotation(String string) {
        return false;
    }

    public boolean isUnparsedEntity(String string) {
        return true;
    }

    public String resolveNamespacePrefix(String string) {
        Namespace namespace = this.getNamespaceForPrefix(string);
        if (namespace != null) {
            return namespace.getURI();
        }
        return null;
    }

    public Object getData() {
        String string;
        if (this.data == null && (string = this.getTextTrim()) != null && string.length() > 0) {
            if (this.datatype instanceof DatabindableDatatype) {
                XSDatatype xSDatatype = this.datatype;
                this.data = xSDatatype.createJavaObject(string, (ValidationContext)this);
            } else {
                this.data = this.datatype.createValue(string, (ValidationContext)this);
            }
        }
        return this.data;
    }

    public void setData(Object object) {
        String string = this.datatype.convertToLexicalValue(object, (SerializationContext)this);
        this.validate(string);
        this.data = object;
        this.setText(string);
    }

    public Element addText(String string) {
        this.validate(string);
        return super.addText(string);
    }

    public void setText(String string) {
        this.validate(string);
        super.setText(string);
    }

    protected void childAdded(Node node) {
        this.data = null;
        super.childAdded(node);
    }

    protected void childRemoved(Node node) {
        this.data = null;
        super.childRemoved(node);
    }

    protected void validate(String string) throws IllegalArgumentException {
        try {
            this.datatype.checkValid(string, (ValidationContext)this);
        }
        catch (DatatypeException datatypeException) {
            throw new IllegalArgumentException(datatypeException.getMessage());
        }
    }
}

