/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import com.google.common.io.BaseEncoding;
import java.nio.charset.Charset;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.FileNameCryptor;
import org.cryptomator.cryptolib.common.MessageDigestSupplier;
import org.cryptomator.siv.SivMode;
import org.cryptomator.siv.UnauthenticCiphertextException;

class FileNameCryptorImpl
implements FileNameCryptor {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final BaseEncoding BASE32 = BaseEncoding.base32();
    private static final ThreadLocal<SivMode> AES_SIV = new ThreadLocal<SivMode>(){

        @Override
        protected SivMode initialValue() {
            return new SivMode();
        }
    };
    private final SecretKey encryptionKey;
    private final SecretKey macKey;

    FileNameCryptorImpl(SecretKey secretKey, SecretKey secretKey2) {
        this.encryptionKey = secretKey;
        this.macKey = secretKey2;
    }

    @Override
    public String hashDirectoryId(String string) {
        byte[] byArray = string.getBytes(UTF_8);
        byte[] byArray2 = AES_SIV.get().encrypt(this.encryptionKey, this.macKey, byArray, (byte[][])new byte[0][]);
        byte[] byArray3 = MessageDigestSupplier.SHA1.get().digest(byArray2);
        return BASE32.encode(byArray3);
    }

    @Override
    public String encryptFilename(String string, byte[] ... byArray) {
        byte[] byArray2 = string.getBytes(UTF_8);
        byte[] byArray3 = AES_SIV.get().encrypt(this.encryptionKey, this.macKey, byArray2, byArray);
        return BASE32.encode(byArray3);
    }

    @Override
    public String decryptFilename(String string, byte[] ... byArray) throws AuthenticationFailedException {
        try {
            byte[] byArray2 = BASE32.decode(string);
            byte[] byArray3 = AES_SIV.get().decrypt(this.encryptionKey, this.macKey, byArray2, byArray);
            return new String(byArray3, UTF_8);
        }
        catch (IllegalBlockSizeException | UnauthenticCiphertextException generalSecurityException) {
            throw new AuthenticationFailedException("Invalid Ciphertext.", generalSecurityException);
        }
    }
}

