/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.FileContentCryptor;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.common.CipherSupplier;
import org.cryptomator.cryptolib.common.MacSupplier;
import org.cryptomator.cryptolib.v1.FileHeaderImpl;

class FileContentCryptorImpl
implements FileContentCryptor {
    private final SecretKey macKey;
    private final SecureRandom random;

    FileContentCryptorImpl(SecretKey secretKey, SecureRandom secureRandom) {
        this.macKey = secretKey;
        this.random = secureRandom;
    }

    @Override
    public int cleartextChunkSize() {
        return 32768;
    }

    @Override
    public int ciphertextChunkSize() {
        return 32816;
    }

    @Override
    public ByteBuffer encryptChunk(ByteBuffer byteBuffer, long l, FileHeader fileHeader) {
        if (byteBuffer.remaining() == 0 || byteBuffer.remaining() > 32768) {
            throw new IllegalArgumentException("Invalid chunk");
        }
        FileHeaderImpl fileHeaderImpl = FileHeaderImpl.cast(fileHeader);
        return this.encryptChunk(byteBuffer.asReadOnlyBuffer(), l, fileHeaderImpl.getNonce(), fileHeaderImpl.getPayload().getContentKey());
    }

    @Override
    public ByteBuffer decryptChunk(ByteBuffer byteBuffer, long l, FileHeader fileHeader, boolean bl) throws AuthenticationFailedException {
        if (byteBuffer.remaining() < 48 || byteBuffer.remaining() > 32816) {
            throw new IllegalArgumentException("Invalid chunk size: " + byteBuffer.remaining() + ", expected range [" + 48 + ", " + 32816 + "]");
        }
        FileHeaderImpl fileHeaderImpl = FileHeaderImpl.cast(fileHeader);
        if (bl && !this.checkChunkMac(fileHeaderImpl.getNonce(), l, byteBuffer.asReadOnlyBuffer())) {
            throw new AuthenticationFailedException("Authentication of chunk " + l + " failed.");
        }
        return this.decryptChunk(byteBuffer.asReadOnlyBuffer(), fileHeaderImpl.getPayload().getContentKey());
    }

    ByteBuffer encryptChunk(ByteBuffer byteBuffer, long l, byte[] byArray, SecretKey secretKey) {
        try {
            byte[] byArray2 = new byte[16];
            this.random.nextBytes(byArray2);
            Cipher cipher = CipherSupplier.AES_CTR.forEncryption(secretKey, new IvParameterSpec(byArray2));
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(16 + cipher.getOutputSize(byteBuffer.remaining()) + 32);
            byteBuffer2.put(byArray2);
            int n = cipher.doFinal(byteBuffer, byteBuffer2);
            ByteBuffer byteBuffer3 = byteBuffer2.asReadOnlyBuffer();
            byteBuffer3.position(16).limit(16 + n);
            byte[] byArray3 = FileContentCryptorImpl.calcChunkMac(this.macKey, byArray, l, byArray2, byteBuffer3);
            assert (byArray3.length == 32);
            byteBuffer2.put(byArray3);
            byteBuffer2.flip();
            return byteBuffer2;
        }
        catch (ShortBufferException shortBufferException) {
            throw new IllegalStateException("Buffer allocated for reported output size apparently not big enough.", shortBufferException);
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new IllegalStateException("Unexpected exception for CTR ciphers.", generalSecurityException);
        }
    }

    ByteBuffer decryptChunk(ByteBuffer byteBuffer, SecretKey secretKey) {
        assert (byteBuffer.remaining() >= 48);
        try {
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
            byteBuffer2.position(0).limit(16);
            byteBuffer2.get(byArray);
            ByteBuffer byteBuffer3 = byteBuffer.asReadOnlyBuffer();
            byteBuffer3.position(16).limit(byteBuffer.limit() - 32);
            Cipher cipher = CipherSupplier.AES_CTR.forDecryption(secretKey, new IvParameterSpec(byArray));
            ByteBuffer byteBuffer4 = ByteBuffer.allocate(cipher.getOutputSize(byteBuffer3.remaining()));
            cipher.doFinal(byteBuffer3, byteBuffer4);
            byteBuffer4.flip();
            return byteBuffer4;
        }
        catch (ShortBufferException shortBufferException) {
            throw new IllegalStateException("Buffer allocated for reported output size apparently not big enough.", shortBufferException);
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new IllegalStateException("Unexpected exception for CTR ciphers.", generalSecurityException);
        }
    }

    boolean checkChunkMac(byte[] byArray, long l, ByteBuffer byteBuffer) {
        assert (byteBuffer.remaining() >= 48);
        ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
        byteBuffer2.position(0).limit(16);
        ByteBuffer byteBuffer3 = byteBuffer.asReadOnlyBuffer();
        byteBuffer3.position(16).limit(byteBuffer.limit() - 32);
        ByteBuffer byteBuffer4 = byteBuffer.asReadOnlyBuffer();
        byteBuffer4.position(byteBuffer.limit() - 32);
        byte[] byArray2 = new byte[16];
        byteBuffer2.get(byArray2);
        byte[] byArray3 = new byte[32];
        byteBuffer4.get(byArray3);
        byte[] byArray4 = FileContentCryptorImpl.calcChunkMac(this.macKey, byArray, l, byArray2, byteBuffer3);
        return MessageDigest.isEqual(byArray3, byArray4);
    }

    private static byte[] calcChunkMac(SecretKey secretKey, byte[] byArray, long l, byte[] byArray2, ByteBuffer byteBuffer) {
        byte[] byArray3 = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(l).array();
        Mac mac = MacSupplier.HMAC_SHA256.withKey(secretKey);
        mac.update(byArray);
        mac.update(byArray3);
        mac.update(byArray2);
        mac.update(byteBuffer);
        return mac.doFinal();
    }
}

