/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.KeyFile;
import org.cryptomator.cryptolib.api.UnsupportedVaultFormatException;
import org.cryptomator.cryptolib.common.AesKeyWrap;
import org.cryptomator.cryptolib.common.MacSupplier;
import org.cryptomator.cryptolib.common.Scrypt;
import org.cryptomator.cryptolib.v1.CryptorImpl;
import org.cryptomator.cryptolib.v1.KeyFileImpl;

class CryptorProviderImpl
implements CryptorProvider {
    private final SecureRandom random;
    private final KeyGenerator encKeyGen;
    private final KeyGenerator macKeyGen;

    public CryptorProviderImpl(SecureRandom secureRandom) {
        this.random = secureRandom;
        try {
            this.encKeyGen = KeyGenerator.getInstance("AES");
            this.encKeyGen.init(256, secureRandom);
            this.macKeyGen = KeyGenerator.getInstance("HmacSHA256");
            this.macKeyGen.init(256, secureRandom);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Hard-coded algorithm doesn't exist.", noSuchAlgorithmException);
        }
    }

    @Override
    public CryptorImpl createNew() {
        SecretKey secretKey = this.encKeyGen.generateKey();
        SecretKey secretKey2 = this.macKeyGen.generateKey();
        return new CryptorImpl(secretKey, secretKey2, this.random);
    }

    @Override
    public CryptorImpl createFromKeyFile(KeyFile keyFile, CharSequence charSequence, int n) throws UnsupportedVaultFormatException, InvalidPassphraseException {
        return this.createFromKeyFile(keyFile, charSequence, new byte[0], n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CryptorImpl createFromKeyFile(KeyFile keyFile, CharSequence charSequence, byte[] byArray, int n) throws UnsupportedVaultFormatException, InvalidPassphraseException {
        KeyFileImpl keyFileImpl = keyFile.as(KeyFileImpl.class);
        byte[] byArray2 = keyFileImpl.scryptSalt;
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        byte[] byArray4 = Scrypt.scrypt(charSequence, byArray3, keyFileImpl.scryptCostParam, keyFileImpl.scryptBlockSize, 32);
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray4, "AES");
            CryptorImpl cryptorImpl = this.createFromKeyFile(keyFileImpl, secretKeySpec, n);
            return cryptorImpl;
        }
        finally {
            Arrays.fill(byArray4, (byte)0);
        }
    }

    private CryptorImpl createFromKeyFile(KeyFileImpl keyFileImpl, SecretKey secretKey, int n) throws UnsupportedVaultFormatException, InvalidPassphraseException {
        if (n != keyFileImpl.getVersion()) {
            throw new UnsupportedVaultFormatException(keyFileImpl.getVersion(), n);
        }
        try {
            SecretKey secretKey2 = AesKeyWrap.unwrap(secretKey, keyFileImpl.macMasterKey, "HmacSHA256");
            Mac mac = MacSupplier.HMAC_SHA256.withKey(secretKey2);
            byte[] byArray = mac.doFinal(ByteBuffer.allocate(4).putInt(n).array());
            if (keyFileImpl.versionMac == null || !MessageDigest.isEqual(byArray, keyFileImpl.versionMac)) {
                throw new UnsupportedVaultFormatException(Integer.MAX_VALUE, n);
            }
            SecretKey secretKey3 = AesKeyWrap.unwrap(secretKey, keyFileImpl.encryptionMasterKey, "AES");
            return new CryptorImpl(secretKey3, secretKey2, this.random);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidPassphraseException();
        }
    }
}

