/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.KeyFile;
import org.cryptomator.cryptolib.common.AesKeyWrap;
import org.cryptomator.cryptolib.common.MacSupplier;
import org.cryptomator.cryptolib.common.Scrypt;
import org.cryptomator.cryptolib.v1.FileContentCryptorImpl;
import org.cryptomator.cryptolib.v1.FileHeaderCryptorImpl;
import org.cryptomator.cryptolib.v1.FileNameCryptorImpl;
import org.cryptomator.cryptolib.v1.KeyFileImpl;

class CryptorImpl
implements Cryptor {
    private final SecretKey encKey;
    private final SecretKey macKey;
    private final SecureRandom random;
    private final FileContentCryptorImpl fileContentCryptor;
    private final FileHeaderCryptorImpl fileHeaderCryptor;
    private final FileNameCryptorImpl fileNameCryptor;

    CryptorImpl(SecretKey secretKey, SecretKey secretKey2, SecureRandom secureRandom) {
        this.encKey = secretKey;
        this.macKey = secretKey2;
        this.random = secureRandom;
        this.fileHeaderCryptor = new FileHeaderCryptorImpl(secretKey, secretKey2, secureRandom);
        this.fileContentCryptor = new FileContentCryptorImpl(secretKey2, secureRandom);
        this.fileNameCryptor = new FileNameCryptorImpl(secretKey, secretKey2);
    }

    @Override
    public FileContentCryptorImpl fileContentCryptor() {
        this.assertNotDestroyed();
        return this.fileContentCryptor;
    }

    @Override
    public FileHeaderCryptorImpl fileHeaderCryptor() {
        this.assertNotDestroyed();
        return this.fileHeaderCryptor;
    }

    @Override
    public FileNameCryptorImpl fileNameCryptor() {
        this.assertNotDestroyed();
        return this.fileNameCryptor;
    }

    @Override
    public boolean isDestroyed() {
        if (this.encKey instanceof Destroyable && this.macKey instanceof Destroyable) {
            return ((Destroyable)this.encKey).isDestroyed() || ((Destroyable)this.macKey).isDestroyed();
        }
        return false;
    }

    @Override
    public void close() {
        this.destroy();
    }

    @Override
    public void destroy() {
        this.destroyQuietly(this.encKey);
        this.destroyQuietly(this.macKey);
    }

    @Override
    public KeyFile writeKeysToMasterkeyFile(CharSequence charSequence, int n) {
        return this.writeKeysToMasterkeyFile(charSequence, new byte[0], n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyFile writeKeysToMasterkeyFile(CharSequence charSequence, byte[] byArray, int n) {
        byte[] byArray2;
        byte[] byArray3;
        Object object;
        this.assertNotDestroyed();
        byte[] byArray4 = new byte[8];
        this.random.nextBytes(byArray4);
        byte[] byArray5 = new byte[byArray4.length + byArray.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        System.arraycopy(byArray, 0, byArray5, byArray4.length, byArray.length);
        byte[] byArray6 = Scrypt.scrypt(charSequence, byArray5, 16384, 8, 32);
        try {
            object = new SecretKeySpec(byArray6, "AES");
            byArray3 = AesKeyWrap.wrap((SecretKey)object, this.encKey);
            byArray2 = AesKeyWrap.wrap((SecretKey)object, this.macKey);
        }
        finally {
            Arrays.fill(byArray6, (byte)0);
        }
        object = MacSupplier.HMAC_SHA256.withKey(this.macKey);
        byte[] byArray7 = ((Mac)object).doFinal(ByteBuffer.allocate(4).putInt(n).array());
        KeyFileImpl keyFileImpl = new KeyFileImpl();
        keyFileImpl.setVersion(n);
        keyFileImpl.scryptSalt = byArray4;
        keyFileImpl.scryptCostParam = 16384;
        keyFileImpl.scryptBlockSize = 8;
        keyFileImpl.encryptionMasterKey = byArray3;
        keyFileImpl.macMasterKey = byArray2;
        keyFileImpl.versionMac = byArray7;
        return keyFileImpl;
    }

    private void destroyQuietly(SecretKey secretKey) {
        try {
            if (secretKey instanceof Destroyable && !((Destroyable)secretKey).isDestroyed()) {
                ((Destroyable)secretKey).destroy();
            }
        }
        catch (DestroyFailedException destroyFailedException) {
            // empty catch block
        }
    }

    private void assertNotDestroyed() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("Cryptor destroyed.");
        }
    }
}

