/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public final class MacSupplier {
    public static final MacSupplier HMAC_SHA256 = new MacSupplier("HmacSHA256");
    private final String macAlgorithm;
    private final ThreadLocal<Mac> threadLocal;

    public MacSupplier(String string) {
        this.macAlgorithm = string;
        this.threadLocal = new Provider();
    }

    public Mac withKey(SecretKey secretKey) {
        try {
            Mac mac = this.threadLocal.get();
            mac.init(secretKey);
            return mac;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException("Invalid key.", invalidKeyException);
        }
    }

    private class Provider
    extends ThreadLocal<Mac> {
        private Provider() {
        }

        @Override
        protected Mac initialValue() {
            try {
                return Mac.getInstance(MacSupplier.this.macAlgorithm);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalArgumentException("Invalid MAC algorithm.", noSuchAlgorithmException);
            }
        }
    }
}

