/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib;

import dagger.internal.Preconditions;
import java.security.SecureRandom;
import javax.inject.Provider;
import org.cryptomator.cryptolib.CryptoLibComponent;
import org.cryptomator.cryptolib.CryptoLibModule;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.common.SecureRandomModule;
import org.cryptomator.cryptolib.common.SecureRandomModule_ProvideFastSecureRandomFactory;
import org.cryptomator.cryptolib.common.SecureRandomModule_ProvideNativeSecureRandomFactory;
import org.cryptomator.cryptolib.v1.Version1CryptorModule;
import org.cryptomator.cryptolib.v1.Version1CryptorModule_ProvideCryptorProviderFactory;

public final class DaggerCryptoLibComponent
implements CryptoLibComponent {
    private Provider<SecureRandom> provideNativeSecureRandomProvider;
    private Provider<SecureRandom> provideFastSecureRandomProvider;
    private Provider<CryptorProvider> provideCryptorProvider;

    private DaggerCryptoLibComponent(Builder builder) {
        assert (builder != null);
        this.initialize(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initialize(Builder builder) {
        this.provideNativeSecureRandomProvider = SecureRandomModule_ProvideNativeSecureRandomFactory.create(builder.secureRandomModule);
        this.provideFastSecureRandomProvider = SecureRandomModule_ProvideFastSecureRandomFactory.create(builder.secureRandomModule, this.provideNativeSecureRandomProvider);
        this.provideCryptorProvider = Version1CryptorModule_ProvideCryptorProviderFactory.create(builder.version1CryptorModule, this.provideFastSecureRandomProvider);
    }

    @Override
    public CryptorProvider version1() {
        return this.provideCryptorProvider.get();
    }

    public static final class Builder {
        private SecureRandomModule secureRandomModule;
        private Version1CryptorModule version1CryptorModule;

        private Builder() {
        }

        public CryptoLibComponent build() {
            if (this.secureRandomModule == null) {
                throw new IllegalStateException(SecureRandomModule.class.getCanonicalName() + " must be set");
            }
            if (this.version1CryptorModule == null) {
                this.version1CryptorModule = new Version1CryptorModule();
            }
            return new DaggerCryptoLibComponent(this);
        }

        @Deprecated
        public Builder cryptoLibModule(CryptoLibModule cryptoLibModule) {
            Preconditions.checkNotNull(cryptoLibModule);
            return this;
        }

        public Builder version1CryptorModule(Version1CryptorModule version1CryptorModule) {
            this.version1CryptorModule = Preconditions.checkNotNull(version1CryptorModule);
            return this;
        }

        public Builder secureRandomModule(SecureRandomModule secureRandomModule) {
            this.secureRandomModule = Preconditions.checkNotNull(secureRandomModule);
            return this;
        }
    }
}

