/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.PerFileSystem;
import org.cryptomator.cryptofs.UncheckedThrows;

@PerFileSystem
class RootDirectoryInitializer {
    private final CryptoPathMapper cryptoPathMapper;

    @Inject
    public RootDirectoryInitializer(CryptoPathMapper cryptoPathMapper) {
        this.cryptoPathMapper = cryptoPathMapper;
    }

    public void initialize(CryptoPath cryptoPath) {
        UncheckedThrows.rethrowUnchecked(IOException.class).from(() -> {
            Path path = this.cryptoPathMapper.getCiphertextDirPath(cryptoPath);
            Files.createDirectories(path, new FileAttribute[0]);
        });
    }
}

