/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import dagger.Module;
import dagger.Provides;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicLong;
import org.cryptomator.cryptofs.EffectiveOpenOptions;
import org.cryptomator.cryptofs.OpenFilePath;
import org.cryptomator.cryptofs.OpenFileSize;
import org.cryptomator.cryptofs.PerOpenFile;
import org.cryptomator.cryptofs.UncheckedThrows;
import org.cryptomator.cryptolib.Cryptors;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;

@Module
class OpenCryptoFileFactoryModule {
    OpenCryptoFileFactoryModule() {
    }

    @Provides
    @PerOpenFile
    public FileChannel provideFileChannel(@OpenFilePath Path path, EffectiveOpenOptions effectiveOpenOptions) {
        return UncheckedThrows.rethrowUnchecked(IOException.class).from(() -> path.getFileSystem().provider().newFileChannel(path, effectiveOpenOptions.createOpenOptionsForEncryptedFile(), new FileAttribute[0]));
    }

    @Provides
    @PerOpenFile
    @OpenFileSize
    public AtomicLong provideFileSize(FileChannel fileChannel, Cryptor cryptor) {
        return UncheckedThrows.rethrowUnchecked(IOException.class).from(() -> {
            long l = fileChannel.size();
            if (l == 0L) {
                return new AtomicLong();
            }
            int n = cryptor.fileHeaderCryptor().headerSize();
            return new AtomicLong(Cryptors.cleartextSize(l - (long)n, cryptor));
        });
    }

    @Provides
    @PerOpenFile
    public FileHeader provideFileHader(FileChannel fileChannel, Cryptor cryptor, EffectiveOpenOptions effectiveOpenOptions) {
        return UncheckedThrows.rethrowUnchecked(IOException.class).from(() -> {
            if (effectiveOpenOptions.truncateExisting() || this.isNewFile(fileChannel, effectiveOpenOptions)) {
                return cryptor.fileHeaderCryptor().create();
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(cryptor.fileHeaderCryptor().headerSize());
            fileChannel.position(0L);
            fileChannel.read(byteBuffer);
            byteBuffer.flip();
            return cryptor.fileHeaderCryptor().decryptHeader(byteBuffer);
        });
    }

    private boolean isNewFile(FileChannel fileChannel, EffectiveOpenOptions effectiveOpenOptions) throws IOException {
        return effectiveOpenOptions.createNew() || effectiveOpenOptions.create() && fileChannel.size() == 0L;
    }
}

