/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.cryptomator.cryptofs.PerProvider;
import org.cryptomator.cryptofs.RunnableThrowingException;

@PerProvider
class FinallyUtil {
    @Inject
    public FinallyUtil() {
    }

    public <E extends Exception> void guaranteeInvocationOf(RunnableThrowingException<? extends E> ... runnableThrowingExceptionArray) throws E {
        this.guaranteeInvocationOf(Arrays.stream(runnableThrowingExceptionArray));
    }

    public <E extends Exception> void guaranteeInvocationOf(Iterable<RunnableThrowingException<? extends E>> iterable) throws E {
        this.guaranteeInvocationOf(StreamSupport.stream(iterable.spliterator(), false));
    }

    public <E extends Exception> void guaranteeInvocationOf(Stream<RunnableThrowingException<? extends E>> stream) throws E {
        this.guaranteeInvocationOf(stream.map(runnableThrowingException -> runnableThrowingException).iterator());
    }

    public <E extends Exception> void guaranteeInvocationOf(Iterator<RunnableThrowingException<E>> iterator) throws E {
        if (iterator.hasNext()) {
            RunnableThrowingException<E> runnableThrowingException = iterator.next();
            try {
                runnableThrowingException.run();
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                this.guaranteeInvocationOf(iterator);
            }
        }
    }
}

