/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Set;

class EffectiveOpenOptions {
    private final Set<OpenOption> options;

    private EffectiveOpenOptions(Set<? extends OpenOption> set) {
        this.options = this.cleanAndValidate(set);
    }

    public static EffectiveOpenOptions from(Set<? extends OpenOption> set) {
        return new EffectiveOpenOptions(set);
    }

    public boolean writable() {
        return this.options.contains(StandardOpenOption.WRITE);
    }

    public boolean readable() {
        return this.options.contains(StandardOpenOption.READ);
    }

    public boolean syncDataAndMetadata() {
        return this.options.contains(StandardOpenOption.SYNC);
    }

    public boolean syncData() {
        return this.syncDataAndMetadata() || this.options.contains(StandardOpenOption.DSYNC);
    }

    public boolean append() {
        return this.options.contains(StandardOpenOption.APPEND);
    }

    public boolean createNew() {
        return this.options.contains(StandardOpenOption.CREATE_NEW);
    }

    public boolean create() {
        return this.options.contains(StandardOpenOption.CREATE);
    }

    public boolean truncateExisting() {
        return this.options.contains(StandardOpenOption.TRUNCATE_EXISTING);
    }

    public boolean deleteOnClose() {
        return this.options.contains(StandardOpenOption.DELETE_ON_CLOSE);
    }

    private Set<OpenOption> cleanAndValidate(Set<? extends OpenOption> set) {
        HashSet<OpenOption> hashSet = new HashSet<OpenOption>(set);
        this.addWriteIfAppendIsPresent(hashSet);
        this.addReadIfWriteIsAbsent(hashSet);
        this.validateAppendIsNotPresentInConjuntionWithTruncateExistingOrRead(set);
        this.removeSparse(hashSet);
        this.removeCreateIfCreateNewIsPresent(hashSet);
        this.removeCreateAndTruncateOptionsIfWriteIsAbsent(hashSet);
        this.validateNoUnsupportedOptionsArePresent(hashSet);
        return hashSet;
    }

    private void addWriteIfAppendIsPresent(Set<OpenOption> set) {
        if (set.contains(StandardOpenOption.APPEND)) {
            set.add(StandardOpenOption.WRITE);
        }
    }

    private void addReadIfWriteIsAbsent(Set<OpenOption> set) {
        if (!set.contains(StandardOpenOption.WRITE)) {
            set.add(StandardOpenOption.READ);
        }
    }

    private void validateAppendIsNotPresentInConjuntionWithTruncateExistingOrRead(Set<? extends OpenOption> set) {
        if (set.contains(StandardOpenOption.APPEND) && (set.contains(StandardOpenOption.READ) || set.contains(StandardOpenOption.TRUNCATE_EXISTING))) {
            throw new IllegalArgumentException("StandardOpenOption APPEND may not be used in conjuction with READ or TRUNCATE_EXISTING");
        }
    }

    private void removeSparse(Set<OpenOption> set) {
        set.remove(StandardOpenOption.SPARSE);
    }

    private void removeCreateAndTruncateOptionsIfWriteIsAbsent(Set<OpenOption> set) {
        if (!set.contains(StandardOpenOption.WRITE)) {
            set.remove(StandardOpenOption.TRUNCATE_EXISTING);
            set.remove(StandardOpenOption.CREATE_NEW);
            set.remove(StandardOpenOption.CREATE);
        }
    }

    private void removeCreateIfCreateNewIsPresent(Set<OpenOption> set) {
        if (set.contains(StandardOpenOption.CREATE_NEW)) {
            set.remove(StandardOpenOption.CREATE);
        }
    }

    private void validateNoUnsupportedOptionsArePresent(Set<OpenOption> set) {
        for (OpenOption openOption : set) {
            if (this.isSupported(openOption)) continue;
            throw new IllegalArgumentException("Unsupported option option " + openOption);
        }
    }

    private boolean isSupported(OpenOption openOption) {
        return StandardOpenOption.class.isInstance(openOption);
    }

    public Set<OpenOption> createOpenOptionsForEncryptedFile() {
        HashSet<OpenOption> hashSet = new HashSet<OpenOption>(this.options);
        hashSet.add(StandardOpenOption.READ);
        hashSet.add(StandardOpenOption.WRITE);
        hashSet.remove(StandardOpenOption.APPEND);
        return hashSet;
    }
}

