/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemImpl;
import org.cryptomator.cryptofs.CryptoFileSystemModule;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProviderComponent;
import org.cryptomator.cryptofs.PerProvider;
import org.cryptomator.cryptofs.UncheckedThrows;

@PerProvider
class CryptoFileSystems {
    private final CryptoFileSystemProviderComponent cryptoFileSystemProviderComponent;
    private final ConcurrentMap<Path, CryptoFileSystemImpl> fileSystems = new ConcurrentHashMap<Path, CryptoFileSystemImpl>();

    @Inject
    public CryptoFileSystems(CryptoFileSystemProviderComponent cryptoFileSystemProviderComponent) {
        this.cryptoFileSystemProviderComponent = cryptoFileSystemProviderComponent;
    }

    public CryptoFileSystemImpl create(Path path, CryptoFileSystemProperties cryptoFileSystemProperties) throws IOException {
        Path path2 = path.normalize();
        return UncheckedThrows.allowUncheckedThrowsOf(IOException.class).from(() -> this.fileSystems.compute(path2, (path, cryptoFileSystemImpl) -> {
            if (cryptoFileSystemImpl == null) {
                return this.cryptoFileSystemProviderComponent.newCryptoFileSystemComponent(CryptoFileSystemModule.cryptoFileSystemModule().withPathToVault((Path)path).withCryptoFileSystemProperties(cryptoFileSystemProperties).build()).cryptoFileSystem();
            }
            throw new FileSystemAlreadyExistsException();
        }));
    }

    public void remove(CryptoFileSystemImpl cryptoFileSystemImpl) {
        this.fileSystems.values().remove(cryptoFileSystemImpl);
    }

    public boolean contains(CryptoFileSystemImpl cryptoFileSystemImpl) {
        return this.fileSystems.containsValue(cryptoFileSystemImpl);
    }

    public CryptoFileSystemImpl get(Path path) {
        Path path3 = path.normalize();
        return this.fileSystems.computeIfAbsent(path3, path2 -> {
            throw new FileSystemNotFoundException(String.format("CryptoFileSystem at %s not initialized", path));
        });
    }
}

