/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.util.concurrent.atomic.LongAdder;
import javax.inject.Inject;
import org.cryptomator.cryptofs.PerFileSystem;

@PerFileSystem
public class CryptoFileSystemStats {
    private final LongAdder bytesRead = new LongAdder();
    private final LongAdder bytesWritten = new LongAdder();
    private final LongAdder bytesDecrypted = new LongAdder();
    private final LongAdder bytesEncrypted = new LongAdder();
    private final LongAdder chunkCacheAccesses = new LongAdder();
    private final LongAdder chunkCacheMisses = new LongAdder();
    private final LongAdder chunkCacheHits = new LongAdder();

    @Inject
    CryptoFileSystemStats() {
    }

    public long pollBytesRead() {
        return this.bytesRead.sumThenReset();
    }

    void addBytesRead(long l) {
        this.bytesRead.add(l);
    }

    public long pollBytesWritten() {
        return this.bytesWritten.sumThenReset();
    }

    void addBytesWritten(long l) {
        this.bytesWritten.add(l);
    }

    public long pollBytesDecrypted() {
        return this.bytesDecrypted.sumThenReset();
    }

    void addBytesDecrypted(long l) {
        this.bytesDecrypted.add(l);
    }

    public long pollBytesEncrypted() {
        return this.bytesEncrypted.sumThenReset();
    }

    void addBytesEncrypted(long l) {
        this.bytesEncrypted.add(l);
    }

    public long pollChunkCacheAccesses() {
        return this.chunkCacheAccesses.sumThenReset();
    }

    void addChunkCacheAccess() {
        this.chunkCacheAccesses.increment();
        this.chunkCacheHits.increment();
    }

    public long pollChunkCacheHits() {
        return Math.max(0L, this.chunkCacheHits.sumThenReset());
    }

    public long pollChunkCacheMisses() {
        return this.chunkCacheMisses.sumThenReset();
    }

    void addChunkCacheMiss() {
        this.chunkCacheMisses.increment();
        this.chunkCacheHits.decrement();
    }
}

