/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.nio.ByteBuffer;
import org.cryptomator.cryptofs.ByteSource;

class ChunkData {
    private final ByteBuffer bytes;
    private boolean written;
    private int length;

    public static ChunkData wrap(ByteBuffer byteBuffer) {
        return new ChunkData(byteBuffer, byteBuffer.limit());
    }

    public static ChunkData emptyWithSize(int n) {
        return new ChunkData(ByteBuffer.allocate(n), 0);
    }

    private ChunkData(ByteBuffer byteBuffer, int n) {
        this.bytes = byteBuffer;
        this.written = false;
        this.length = n;
    }

    public boolean wasWritten() {
        return this.written;
    }

    public void truncate(int n) {
        if (this.length > n) {
            this.length = n;
            this.written = true;
        }
    }

    public CopyWithoutDirection copyData() {
        return this.copyDataStartingAt(0);
    }

    public CopyWithoutDirection copyDataStartingAt(final int n) {
        return new CopyWithoutDirection(){

            @Override
            public void to(ByteBuffer byteBuffer) {
                ChunkData.this.bytes.limit(Math.min(ChunkData.this.length, byteBuffer.remaining() + n));
                ChunkData.this.bytes.position(n);
                byteBuffer.put(ChunkData.this.bytes);
            }

            @Override
            public void from(ByteBuffer byteBuffer) {
                this.from(ByteSource.from(byteBuffer));
            }

            @Override
            public void from(ByteSource byteSource) {
                ChunkData.this.written = true;
                ChunkData.this.bytes.limit(ChunkData.this.bytes.capacity());
                ChunkData.this.bytes.position(n);
                byteSource.copyTo(ChunkData.this.bytes);
                ChunkData.this.length = Math.max(ChunkData.this.length, ChunkData.this.bytes.position());
            }
        };
    }

    public ByteBuffer asReadOnlyBuffer() {
        ByteBuffer byteBuffer = this.bytes.asReadOnlyBuffer();
        byteBuffer.position(0);
        byteBuffer.limit(this.length);
        return byteBuffer;
    }

    public String toString() {
        return String.format("ChunkData(written: %s, length: %d, capacity: %d)", this.written, this.length, this.bytes.capacity());
    }

    public static interface CopyWithoutDirection {
        public void to(ByteBuffer var1);

        public void from(ByteBuffer var1);

        public void from(ByteSource var1);
    }
}

