/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import org.cryptomator.cryptofs.CryptoFileAttributeProvider;
import org.cryptomator.cryptofs.UnsupportedFileAttributeViewException;

abstract class AbstractCryptoFileAttributeView<S extends BasicFileAttributes, T extends BasicFileAttributeView>
implements BasicFileAttributeView {
    protected final Path ciphertextPath;
    protected final CryptoFileAttributeProvider fileAttributeProvider;
    protected final T delegate;
    private final Class<S> attributesType;

    public AbstractCryptoFileAttributeView(Path path, CryptoFileAttributeProvider cryptoFileAttributeProvider, Class<S> clazz, Class<T> clazz2) throws UnsupportedFileAttributeViewException {
        this.ciphertextPath = path;
        this.fileAttributeProvider = cryptoFileAttributeProvider;
        this.attributesType = clazz;
        this.delegate = (BasicFileAttributeView)path.getFileSystem().provider().getFileAttributeView(path, clazz2, new LinkOption[0]);
        if (this.delegate == null) {
            throw new UnsupportedFileAttributeViewException();
        }
    }

    public final S readAttributes() throws IOException {
        return this.fileAttributeProvider.readAttributes(this.ciphertextPath, this.attributesType);
    }

    @Override
    public void setTimes(FileTime fileTime, FileTime fileTime2, FileTime fileTime3) throws IOException {
        this.delegate.setTimes(fileTime, fileTime2, fileTime3);
    }
}

