/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache.memcached;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.impl.client.cache.memcached.MemcachedCacheEntry;
import org.apache.http.impl.client.cache.memcached.MemcachedSerializationException;

public class MemcachedCacheEntryImpl
implements MemcachedCacheEntry {
    private String key;
    private HttpCacheEntry httpCacheEntry;

    public MemcachedCacheEntryImpl(String string, HttpCacheEntry httpCacheEntry) {
        this.key = string;
        this.httpCacheEntry = httpCacheEntry;
    }

    public MemcachedCacheEntryImpl() {
    }

    @Override
    public synchronized byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.key);
            objectOutputStream.writeObject(this.httpCacheEntry);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            throw new MemcachedSerializationException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public synchronized String getStorageKey() {
        return this.key;
    }

    @Override
    public synchronized HttpCacheEntry getHttpCacheEntry() {
        return this.httpCacheEntry;
    }

    @Override
    public synchronized void set(byte[] byArray) {
        HttpCacheEntry httpCacheEntry;
        String string;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            string = (String)objectInputStream.readObject();
            httpCacheEntry = (HttpCacheEntry)objectInputStream.readObject();
            objectInputStream.close();
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            throw new MemcachedSerializationException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MemcachedSerializationException(classNotFoundException);
        }
        this.key = string;
        this.httpCacheEntry = httpCacheEntry;
    }
}

