/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.cache.RequestProtocolError;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class RequestProtocolCompliance {
    private final boolean weakETagOnPutDeleteAllowed;
    private static final List<String> disallowedWithNoCache = Arrays.asList("min-fresh", "max-stale", "max-age");

    public RequestProtocolCompliance() {
        this.weakETagOnPutDeleteAllowed = false;
    }

    public RequestProtocolCompliance(boolean bl) {
        this.weakETagOnPutDeleteAllowed = bl;
    }

    public List<RequestProtocolError> requestIsFatallyNonCompliant(HttpRequest httpRequest) {
        ArrayList<RequestProtocolError> arrayList = new ArrayList<RequestProtocolError>();
        RequestProtocolError requestProtocolError = this.requestHasWeakETagAndRange(httpRequest);
        if (requestProtocolError != null) {
            arrayList.add(requestProtocolError);
        }
        if (!this.weakETagOnPutDeleteAllowed && (requestProtocolError = this.requestHasWeekETagForPUTOrDELETEIfMatch(httpRequest)) != null) {
            arrayList.add(requestProtocolError);
        }
        if ((requestProtocolError = this.requestContainsNoCacheDirectiveWithFieldName(httpRequest)) != null) {
            arrayList.add(requestProtocolError);
        }
        return arrayList;
    }

    public void makeRequestCompliant(HttpRequestWrapper httpRequestWrapper) throws ClientProtocolException {
        if (this.requestMustNotHaveEntity(httpRequestWrapper)) {
            ((HttpEntityEnclosingRequest)((Object)httpRequestWrapper)).setEntity(null);
        }
        this.verifyRequestWithExpectContinueFlagHas100continueHeader(httpRequestWrapper);
        this.verifyOPTIONSRequestWithBodyHasContentType(httpRequestWrapper);
        this.decrementOPTIONSMaxForwardsIfGreaterThen0(httpRequestWrapper);
        this.stripOtherFreshnessDirectivesWithNoCache(httpRequestWrapper);
        if (this.requestVersionIsTooLow(httpRequestWrapper) || this.requestMinorVersionIsTooHighMajorVersionsMatch(httpRequestWrapper)) {
            httpRequestWrapper.setProtocolVersion(HttpVersion.HTTP_1_1);
        }
    }

    private void stripOtherFreshnessDirectivesWithNoCache(HttpRequest httpRequest) {
        ArrayList<HeaderElement> arrayList = new ArrayList<HeaderElement>();
        boolean bl = false;
        for (Header header : httpRequest.getHeaders("Cache-Control")) {
            for (HeaderElement headerElement : header.getElements()) {
                if (!disallowedWithNoCache.contains(headerElement.getName())) {
                    arrayList.add(headerElement);
                }
                if (!"no-cache".equals(headerElement.getName())) continue;
                bl = true;
            }
        }
        if (!bl) {
            return;
        }
        httpRequest.removeHeaders("Cache-Control");
        httpRequest.setHeader("Cache-Control", this.buildHeaderFromElements(arrayList));
    }

    private String buildHeaderFromElements(List<HeaderElement> list) {
        StringBuilder stringBuilder = new StringBuilder("");
        boolean bl = true;
        for (HeaderElement headerElement : list) {
            if (!bl) {
                stringBuilder.append(",");
            } else {
                bl = false;
            }
            stringBuilder.append(headerElement.toString());
        }
        return stringBuilder.toString();
    }

    private boolean requestMustNotHaveEntity(HttpRequest httpRequest) {
        return "TRACE".equals(httpRequest.getRequestLine().getMethod()) && httpRequest instanceof HttpEntityEnclosingRequest;
    }

    private void decrementOPTIONSMaxForwardsIfGreaterThen0(HttpRequest httpRequest) {
        if (!"OPTIONS".equals(httpRequest.getRequestLine().getMethod())) {
            return;
        }
        Header header = httpRequest.getFirstHeader("Max-Forwards");
        if (header == null) {
            return;
        }
        httpRequest.removeHeaders("Max-Forwards");
        int n = Integer.parseInt(header.getValue());
        httpRequest.setHeader("Max-Forwards", Integer.toString(n - 1));
    }

    private void verifyOPTIONSRequestWithBodyHasContentType(HttpRequest httpRequest) {
        if (!"OPTIONS".equals(httpRequest.getRequestLine().getMethod())) {
            return;
        }
        if (!(httpRequest instanceof HttpEntityEnclosingRequest)) {
            return;
        }
        this.addContentTypeHeaderIfMissing((HttpEntityEnclosingRequest)httpRequest);
    }

    private void addContentTypeHeaderIfMissing(HttpEntityEnclosingRequest httpEntityEnclosingRequest) {
        if (httpEntityEnclosingRequest.getEntity().getContentType() == null) {
            ((AbstractHttpEntity)httpEntityEnclosingRequest.getEntity()).setContentType(ContentType.APPLICATION_OCTET_STREAM.getMimeType());
        }
    }

    private void verifyRequestWithExpectContinueFlagHas100continueHeader(HttpRequest httpRequest) {
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            if (((HttpEntityEnclosingRequest)httpRequest).expectContinue() && ((HttpEntityEnclosingRequest)httpRequest).getEntity() != null) {
                this.add100ContinueHeaderIfMissing(httpRequest);
            } else {
                this.remove100ContinueHeaderIfExists(httpRequest);
            }
        } else {
            this.remove100ContinueHeaderIfExists(httpRequest);
        }
    }

    private void remove100ContinueHeaderIfExists(HttpRequest httpRequest) {
        boolean bl = false;
        Header[] headerArray = httpRequest.getHeaders("Expect");
        ArrayList<HeaderElement> arrayList = new ArrayList<HeaderElement>();
        for (Header header : headerArray) {
            for (HeaderElement headerElement : header.getElements()) {
                if (!"100-continue".equalsIgnoreCase(headerElement.getName())) {
                    arrayList.add(headerElement);
                    continue;
                }
                bl = true;
            }
            if (bl) {
                httpRequest.removeHeader(header);
                for (HeaderElement headerElement : arrayList) {
                    BasicHeader basicHeader = new BasicHeader("Expect", headerElement.getName());
                    httpRequest.addHeader(basicHeader);
                }
                return;
            }
            arrayList = new ArrayList();
        }
    }

    private void add100ContinueHeaderIfMissing(HttpRequest httpRequest) {
        boolean bl = false;
        for (Header header : httpRequest.getHeaders("Expect")) {
            for (HeaderElement headerElement : header.getElements()) {
                if (!"100-continue".equalsIgnoreCase(headerElement.getName())) continue;
                bl = true;
            }
        }
        if (!bl) {
            httpRequest.addHeader("Expect", "100-continue");
        }
    }

    protected boolean requestMinorVersionIsTooHighMajorVersionsMatch(HttpRequest httpRequest) {
        ProtocolVersion protocolVersion = httpRequest.getProtocolVersion();
        if (protocolVersion.getMajor() != HttpVersion.HTTP_1_1.getMajor()) {
            return false;
        }
        return protocolVersion.getMinor() > HttpVersion.HTTP_1_1.getMinor();
    }

    protected boolean requestVersionIsTooLow(HttpRequest httpRequest) {
        return httpRequest.getProtocolVersion().compareToVersion(HttpVersion.HTTP_1_1) < 0;
    }

    public HttpResponse getErrorForRequest(RequestProtocolError requestProtocolError) {
        switch (requestProtocolError) {
            case BODY_BUT_NO_LENGTH_ERROR: {
                return new BasicHttpResponse(new BasicStatusLine(HttpVersion.HTTP_1_1, 411, ""));
            }
            case WEAK_ETAG_AND_RANGE_ERROR: {
                return new BasicHttpResponse(new BasicStatusLine(HttpVersion.HTTP_1_1, 400, "Weak eTag not compatible with byte range"));
            }
            case WEAK_ETAG_ON_PUTDELETE_METHOD_ERROR: {
                return new BasicHttpResponse(new BasicStatusLine(HttpVersion.HTTP_1_1, 400, "Weak eTag not compatible with PUT or DELETE requests"));
            }
            case NO_CACHE_DIRECTIVE_WITH_FIELD_NAME: {
                return new BasicHttpResponse(new BasicStatusLine(HttpVersion.HTTP_1_1, 400, "No-Cache directive MUST NOT include a field name"));
            }
        }
        throw new IllegalStateException("The request was compliant, therefore no error can be generated for it.");
    }

    private RequestProtocolError requestHasWeakETagAndRange(HttpRequest httpRequest) {
        String string = httpRequest.getRequestLine().getMethod();
        if (!"GET".equals(string)) {
            return null;
        }
        Header header = httpRequest.getFirstHeader("Range");
        if (header == null) {
            return null;
        }
        Header header2 = httpRequest.getFirstHeader("If-Range");
        if (header2 == null) {
            return null;
        }
        String string2 = header2.getValue();
        if (string2.startsWith("W/")) {
            return RequestProtocolError.WEAK_ETAG_AND_RANGE_ERROR;
        }
        return null;
    }

    private RequestProtocolError requestHasWeekETagForPUTOrDELETEIfMatch(HttpRequest httpRequest) {
        String string = httpRequest.getRequestLine().getMethod();
        if (!"PUT".equals(string) && !"DELETE".equals(string)) {
            return null;
        }
        Header header = httpRequest.getFirstHeader("If-Match");
        if (header != null) {
            String string2 = header.getValue();
            if (string2.startsWith("W/")) {
                return RequestProtocolError.WEAK_ETAG_ON_PUTDELETE_METHOD_ERROR;
            }
        } else {
            Header header2 = httpRequest.getFirstHeader("If-None-Match");
            if (header2 == null) {
                return null;
            }
            String string3 = header2.getValue();
            if (string3.startsWith("W/")) {
                return RequestProtocolError.WEAK_ETAG_ON_PUTDELETE_METHOD_ERROR;
            }
        }
        return null;
    }

    private RequestProtocolError requestContainsNoCacheDirectiveWithFieldName(HttpRequest httpRequest) {
        for (Header header : httpRequest.getHeaders("Cache-Control")) {
            for (HeaderElement headerElement : header.getElements()) {
                if (!"no-cache".equalsIgnoreCase(headerElement.getName()) || headerElement.getValue() == null) continue;
                return RequestProtocolError.NO_CACHE_DIRECTIVE_WITH_FIELD_NAME;
            }
        }
        return null;
    }
}

